<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Log;

class AdminEventList implements FromView
{
    public $datas;

    public function __construct($datas)
    {
        $this->datas = $datas;
    }

    public function view(): View
    {
        try {
            $datas = $this->datas;
            $view= view('backend.page.event.event-form-data.excel', compact('datas'));
            return $view;
        } catch (\Exception $e) {
            Log::error('AdminEventList excel error: ' . json_encode($e));
            return '';
        }
    }
}
