<?php

namespace App\Exports;

use Log;
use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Maatwebsite\Excel\Concerns\FromView;
use Carbon\Carbon;

class PartnerCustomerExport implements FromView
{
    public function view(): View
    {
        try {
            $todayDate = Carbon::now()->format('d-m-Y');
            $datas = User::where('status','N')->where('role','Customer')->where('partner_code', Auth::user()->code)->orderBy('id','DESC')->get();
            return view('frontend.become_a_partner.customer.excel', compact('datas','todayDate'));
        } catch (\Exception $e) {
            Log::error('PartnerCustomerExport excel error: ' . json_encode($e));
            return '';
        }
    }
}
