<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Posts;
use App\Models\BlogCategory;
use Intervention\Image\Facades\Image;
use App\Models\Language;
use App\Models\PostComment;
use Str;
use Illuminate\Support\Facades\Auth;
use DataTables;

class PostController extends Controller
{
    //
    public function blogList(Request $request)
    {
        if($request->ajax()){
            // if(!$request->category_id || $request->category_id=='All'){
                $posts = Posts::where('post_type','post')->orderBy('id','DESC');
            // }else{
            //     $posts=Posts::where('blog_category_id',$request->category_id)->where('post_type','post')->orderBy('id','DESC');
            // }

            return DataTables::of($posts)
                ->addColumn('action', function($data) {
                    $html='<a href="'.route('post.preview',$data->id).'" class="btn btn-outline-success"><i class="fas fa-eye"></i></a>';
                    $html .='<a href="'.route('post.edit',$data->id).'" class="btn btn-outline-info"><i class="fas fa-edit"></i></a>';
                    if($data->post_status=='Trash'){
                        $html .='<a href="'.route('post.delete',$data->id).'" onclick="return confirm(\'Are you sure you want to delete this item?\');" class="btn btn-outline-danger"  title="Permanently delete"><i class="fas fa-trash"></i></a>';
                    }else{
                        $html .='<a href="'.route('post.delete',$data->id).'" onclick="return confirm(\'Are you sure you want to trash this item?\');" class="btn btn-outline-warning" title="Trash Item"><i class="fas fa-trash"></i></a>';
                    }
                    if($data->language=='en'){
                        $html .='<a href="'.route('post.comment',$data->id).'" class="btn btn-outline-info"><i class="fas fa-comment"></i></a>';
                    }elseif($data->default_language_page){
                        $html .='<a href="'.route('post.comment',$data->default_language_page).'" class="btn btn-outline-info"><i class="fas fa-comment"></i></a>';
                    }
                    return $html;
                })
                ->editColumn('created_at', function($data) {
                    return date('Y-m-d', strtotime($data->created_at));
                })
                ->addIndexColumn()
                ->rawColumns(['action'])  // Allow HTML in the 'action' column
                ->make(true);
        }

        $categorys=BlogCategory::where('language','en')->where('type','post')->get();
        return view('backend.blog.index',compact('categorys'));
    }


    public function create()
    {
        $languages=Language::all();
        $defaultLanguagePagesList=Posts::where('post_type','post')->where('language','en')->where('post_status','Published')->get();
        $categorys=BlogCategory::where('language','en')->where('type','post')->get();
        return view('backend.blog.add',compact('languages','categorys','defaultLanguagePagesList'));
    }

    public function store(Request $request){
        $request->validate([
            'image'=>'nullable|mimes:jpg,png,jpeg,gif,svg',
            'video'=>'nullable|mimes:mp4,mov,ogg,qt',
            'post_title'=>'required',
            'post_content'=>'required',
            'language'=>'required',
            'blog_category_id'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
            'media_type'=>'required',
            'location'=>'required',
        ]);

        if($request->language =='en' && $request->post_slug){
            $check_data=Posts::where('post_slug',$request->post_slug)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->language !='en' && $request->default_language_page){
            $check_data=Posts::where('default_language_page',$request->default_language_page)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $notification=array(
                'message'=>'Please first add english language page!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    =   new Posts();
        if($request->media_type=='Image'){
            $image_name     =   $request->file('image');
            if($image_name){
                $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                $path           =   public_path('upload/blog/'.$name_gen);
                Image::make($image_name->getRealPath())->save($path);
                $last_img       =   'upload/blog/'.$name_gen;
                $data->image            =   $last_img;
            }else{
                $notification=array(
                    'message'=>'Please Upload Image',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->media_type=='Video'){
            if($request->video_type=='MP4'){
                $video = $request->file('video');
                if(!empty($video) && $video != null){
                    $fileExentsion              = $video->extension();
                    $fileName                   = $video->getClientOriginalName();
                    $fileFullName               = time()."_".$fileName;
                    $path                       = Str::slug($fileFullName).".".$fileExentsion;
                    $video->move(public_path('upload/blog/'), $path);
                    $fullpath                   = 'upload/blog/'.$path;
                    $data->video            =   $fullpath;
                }else{
                    $notification=array(
                        'message'=>'Please Upload Video',
                        'alert-type'=>'warning'
                    );
                    return redirect()->back()->with($notification);
                }
            }elseif($request->video_type=='Youtube' && $request->youtube){
                $data->youtube            =   $request->youtube;
            }else{
                $notification=array(
                    'message'=>'Please Enter Youtube Link',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }

        $data->post_title       =   $request->post_title;
        $data->location       =   $request->location;
        $data->post_content     =   $request->post_content;
        if($request->language =='en'){
            $data->post_slug        =   trim(strtolower($request->post_slug));
        }else{
            $data->default_language_page = $request->default_language_page;
        }
        $data->post_type        =   'post';
        $data->blog_category_id =   $request->blog_category_id;
        $data->language         =   $request->language;
        $data->media_type         =   $request->media_type;
        $data->video_type         =   $request->video_type;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->created_by       =   Auth::user()->id;

        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('post.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }


    public function edit($id)
    {
        $languages=Language::all();
        $data       =   Posts::find($id);
        $defaultLanguagePagesList=Posts::where('post_type','post')->where('language','en')->where('post_status','Published')->get();
        $categorys  =   BlogCategory::where('language','en')->where('type','post')->get();
        return view('backend.blog.edit',compact('data','categorys','languages','defaultLanguagePagesList'));
    }


    public function getCategory(Request $request)
    {
        if($request->id=='All'){
            $datas=Posts::where('post_type','post')->get();
            foreach($datas as $key =>$data){ ?>
                <tr>
                    <td><?= $key + 1  ?></td>
                    <td><?= $data->post_title  ?></td>
                    <td><?= $data->created_at  ?></td>
                    <td><?= $data->post_status  ?></td>
                    <td>
                        <a href="<?=route('post.preview',$data->id) ?>" class="btn btn-outline-success"><i class="fas fa-eye"></i></a>
                        <a href="<?=route('post.edit',$data->id) ?>" class="btn btn-outline-info"><i class="fas fa-edit"></i></a>
                        <?php if($data->post_status=='Trash'){ ?>
                            <a href="<?=route('post.delete',$data->id) ?>" onclick="return confirm('Are you sure you want to delete this item?');" class="btn btn-outline-danger"><i class="fas fa-trash"></i></a>
                        <?php }else{?>
                            <a href="<?=route('post.delete',$data->id) ?>" onclick="return confirm('Are you sure you want to trash this item?');" class="btn btn-outline-warning" title="Trash Item"><i class="fas fa-trash"></i></a>
                        <?php } ?>
                        <?php if($data->language=='en'){ ?>
                            <a href="<?=route('post.comment',$data->id)?>" class="btn btn-outline-info"><i class="fas fa-comment"></i></a>
                        <?php }elseif($data->default_language_page){?>
                                <a href="<?=route('post.comment',$data->default_language_page)?>" class="btn btn-outline-info"><i class="fas fa-comment"></i></a>
                        <?php } ?>
                    </td>
                </tr>
            <?php
            }
        }else{
            $datas=Posts::where('blog_category_id',$request->id)->where('post_type','post')->get();
            foreach($datas as $key =>$data){ ?>
                <tr>
                    <td><?= $key + 1  ?></td>
                    <td><?= $data->post_title  ?></td>
                    <td><?= $data->created_at  ?></td>
                    <td><?= $data->post_status  ?></td>
                    <td>
                        <a href="<?=route('post.preview',$data->id) ?>" class="btn btn-outline-success"><i class="fas fa-eye"></i></a>
                        <a href="<?=route('post.edit',$data->id) ?>" class="btn btn-outline-info"><i class="fas fa-edit"></i></a>
                        <?php if($data->post_status=='Trash'){ ?>
                            <a href="<?=route('post.delete',$data->id) ?>" onclick="return confirm('Are you sure you want to delete this item?');" class="btn btn-outline-danger"><i class="fas fa-trash"></i></a>
                        <?php }else{?>
                            <a href="<?=route('post.delete',$data->id) ?>" onclick="return confirm('Are you sure you want to trash this item?');" class="btn btn-outline-warning" title="Trash Item"><i class="fas fa-trash"></i></a>
                        <?php } ?>
                        <?php if($data->language=='en'){ ?>
                            <a href="<?=route('post.comment',$data->id)?>" class="btn btn-outline-info"><i class="fas fa-comment"></i></a>
                        <?php }elseif($data->default_language_page){?>
                                <a href="<?=route('post.comment',$data->default_language_page)?>" class="btn btn-outline-info"><i class="fas fa-comment"></i></a>
                        <?php } ?>
                    </td>
                </tr>
            <?php
            }
        }
    }

    public function update(Request $request, $id){
        $request->validate([
            'image'=>'nullable|mimes:jpg,png,jpeg,gif,svg',
            'post_title'=>'required',
            'post_content'=>'required',
            'language'=>'required',
            'blog_category_id'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
            'post_status'=>'required',
            'video'=>'nullable|mimes:mp4,mov,ogg,qt',
            'media_type'=>'required',
        ]);

        if($request->language !='en'){
            $check_data=Posts::where('id','!=',$id)->where('default_language_page',$request->default_language_page)->where('language',$request->language)->where('post_type','post')->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }
        $old_image=$request->old_image;
        $old_video=$request->old_video;

        $data= Posts::find($id);

        // ---------------------------------------------------------------------------------------------------
        if($request->media_type=='Image'){
            $image_name     =   $request->file('image');
            if($image_name ||$old_image){
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/blog/'.$name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/blog/'.$name_gen;
                    $data->image            =   $last_img;
                    if($old_image){
                        $unlink=@unlink($old_image);
                    }
                }
            }else{
                $notification=array(
                    'message'=>'Please Upload Image',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->media_type=='Video'){
            if($request->video_type=='MP4'){
                $video = $request->file('video');
                if((!empty($video) && $video != null) ||$old_video){
                    if(!empty($video) && $video != null){
                        $fileExentsion              = $video->extension();
                        $fileName                   = $video->getClientOriginalName();
                        $fileFullName               = time()."_".$fileName;
                        $path                       = Str::slug($fileFullName).".".$fileExentsion;
                        $video->move(public_path('upload/blog/'), $path);
                        $fullpath                   = 'upload/blog/'.$path;
                        $data->video            =   $fullpath;
                        if($old_video){
                            $unlink=@unlink($old_video);
                        }
                    }
                }else{
                    $notification=array(
                        'message'=>'Please Upload Video',
                        'alert-type'=>'warning'
                    );
                    return redirect()->back()->with($notification);
                }
            }elseif($request->video_type=='Youtube' && $request->youtube){
                $data->youtube            =   $request->youtube;
            }else{
                $notification=array(
                    'message'=>'Please Enter Youtube Link',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }
        // ---------------------------------------------------------------------------------------------------
        if($request->language !='en'){
            $data->default_language_page = $request->default_language_page;
        }
        $data->post_title       =   $request->post_title;
        $data->location       =   $request->location;
        $data->post_content     =   $request->post_content;
        $data->blog_category_id =   $request->blog_category_id;
        $data->language         =   $request->language;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->post_status         =   $request->post_status;
        $data->media_type         =   $request->media_type;
        $data->video_type         =   $request->video_type;
        $data->updated_by=Auth::user()->id;
        $data->created_at         =   $request->created_at;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('post.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function preview($id){
        $languages=Language::all();
        $data       =   Posts::find($id);
        return view('backend.blog.view',compact('data','languages'));
    }

    public function delete($id){
        $data       =   Posts::find($id);
        if($data->post_status=='Trash'){
            $result=$data->delete();
        }else{
            $data->post_status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('post.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function GetCategoryName(Request $request){
        $code=$request->code;
        return BlogCategory::where('language',$code)->where('type','post')->get();
    }

    public function comment($id){
        $datas=PostComment::where('post_id',$id)->orderBy('id','DESC')->get();
        return view('backend.blog.comment',compact('datas'));
    }
    public function commentUpdate($id){
        $data=PostComment::find($id);
        if($data->status==1){
            $result=$data->delete();
        }else{
            $data->status='1';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

}
