<?php

namespace App\Http\Controllers\backend\page\contact_us;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ContactUsFormData;
use DataTables;

class ContactFormDataShow extends Controller
{
    public function index(Request $request){
        if($request->ajax()){
            $products = ContactUsFormData::orderBy('id','DESC');

            return DataTables::of($products)
                ->editColumn('phone', function($data) {
                    return '(+'.$data->calling_code.') '. $data->phone;
                })
                ->editColumn('created_at', function($data) {
                    return date('d/m/Y', strtotime($data->created_at));
                })
                ->addIndexColumn()
                ->make(true);
        }

        return view('backend.page.contact-us.form-data.index');
    }
}
