<?php

namespace App\Http\Controllers\backend\page\general_page\vission_mission;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\VissionAndMission;
use App\Models\VissionAndMissionFeature;
use App\Models\VissionAndMissionOurCoreValues;
use Illuminate\Support\Facades\Auth;
use App\Models\Language;
use Intervention\Image\Facades\Image;

class VissionAndMissionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas=VissionAndMission::all();
        return view('backend.page.general-page.vission-and-mission.index',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages      =   Language::all();
        return view('backend.page.general-page.vission-and-mission.add',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'banner_image'=>'required|image|mimes:jpeg,png,jpg,gif,svg',
            'title'=>'required',
            'slug'=>'required',
            'sub_title'=>'required',
            'our_core_values_text'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required'
        ]);

        $check_data=VissionAndMission::where('slug',$request->slug)->where('language',$request->language)->count();
        if($check_data){
            $notification=array(
                'message'=>'Title already exists!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    =   new VissionAndMission();
        //--------------------------------------
        $image_1_name     =   $request->file('banner_image');
        $image_1_name_gen       =   hexdec(uniqid()).'.'.$image_1_name->getClientOriginalExtension();
        $path           =   public_path('upload/vission-and-mission/'.$image_1_name_gen);
        Image::make($image_1_name->getRealPath())->save($path);
        $last_img       =   'upload/vission-and-mission/'.$image_1_name_gen;
        $data->banner_image            =   $last_img;
        //--------------------------------------

        $data->title       =   $request->title;
        $data->sub_title     =   $request->sub_title;
        $data->slug        =   trim(strtolower($request->slug));
        $data->our_core_values_text         =   $request->our_core_values_text;

        $data->language         =   $request->language;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->created_by       =   Auth::user()->id;
        $result=$data->save();

        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('page.vission-and-mission.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages  =Language::all();
        $data       =   VissionAndMission::find($id);
        return view('backend.page.general-page.vission-and-mission.edit',compact('data','languages'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'banner_image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'title'=>'required',
            'sub_title'=>'required',
            'our_core_values_text'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
            'status'=>'required',
        ]);
        $old_banner_image=$request->old_banner_image;

        $check_data=VissionAndMission::where('id','!=',$id)->where('slug',$request->slug)->where('language',$request->language)->count();
        if($check_data){
            $notification=array(
                'message'=>'Title already exists!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    = VissionAndMission::find($id);
        //--------------------------------------
        $image_1_name     =   $request->file('banner_image');
        if($image_1_name){
            $image_1_name_gen       =   hexdec(uniqid()).'.'.$image_1_name->getClientOriginalExtension();
            $path           =   public_path('upload/vission-and-mission/'.$image_1_name_gen);
            Image::make($image_1_name->getRealPath())->save($path);
            $last_img       =   'upload/vission-and-mission/'.$image_1_name_gen;
            $data->banner_image            =   $last_img;
            if($old_banner_image){
                $unlink=@unlink($old_banner_image);
            }
        }
        //--------------------------------------

        $data->title       =   $request->title;
        $data->sub_title     =   $request->sub_title;
        // $data->slug        =   trim(strtolower($request->slug));
        $data->our_core_values_text         =   $request->our_core_values_text;

        $data->language         =   $request->language;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->status         =   $request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('page.vission-and-mission.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   VissionAndMission::find($id);
        if($data->status=='Trash'){
            $dataCheck=VissionAndMissionFeature::where('vission_mission_id',$id)->count();
            $dataCheck1=VissionAndMissionOurCoreValues::where('vission_mission_id',$id)->count();
            if($dataCheck==0 && $dataCheck1==0){
                $result=$data->delete();
            }else{
                $notification=array(
                    'message'=>'First delete associated Category!!',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
