<?php

namespace App\Http\Controllers\backend\page\go_online;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\GoOnlineCreateWebsite;
use App\Models\GoOnlineCreateWebsiteFeatures;
use App\Models\GoOnlineCreateWebsiteTheme;
use App\Models\Language;
use Intervention\Image\Facades\Image;
use Str;

class GoOnlineCreateWebsiteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = GoOnlineCreateWebsite::all();
        return view('backend.page.go-online.create-website.index', compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages  = Language::all();
        $defaultLanguagePagesList = GoOnlineCreateWebsite::where('language', 'en')->where('status', 'Published')->get();
        return view('backend.page.go-online.create-website.add', compact('languages', 'defaultLanguagePagesList'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'banner_image' => 'required|image|mimes:jpeg,png,jpg,gif,svg',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'video' => 'nullable|mimes:mp4,mov,ogg,qt',
            'thumbnail_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'title' => 'required',
            'description' => 'required',
            'media_type' => 'required',
            'title_2' => 'required',
            'button_text' => 'required',
            'button_link' => 'required',
            'text_1' => 'required',
            'text_2' => 'required',
            'language' => 'required',
            'meta_key' => 'required',
            'meta_title' => 'required',
            'meta_description' => 'required',
            'media_type' => 'required',
        ]);
        if ($request->language == 'en' && $request->slug) {
            $check_data = GoOnlineCreateWebsite::where('slug', $request->slug)->where('language', $request->language)->count();
            if ($check_data) {
                $notification = array(
                    'message' => 'Title already exists!!.',
                    'alert-type' => 'warning'
                );
                return redirect()->back()->with($notification);
            }
        } elseif ($request->language != 'en' && $request->default_language_page) {
            $check_data = GoOnlineCreateWebsite::where('default_language_page', $request->default_language_page)->where('language', $request->language)->count();
            if ($check_data) {
                $notification = array(
                    'message' => 'Title already exists!!.',
                    'alert-type' => 'warning'
                );
                return redirect()->back()->with($notification);
            }
        } else {
            $notification = array(
                'message' => 'Please first add english language page!!.',
                'alert-type' => 'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    =   new GoOnlineCreateWebsite();
        //--------------------------------------
        $image_1_name     =   $request->file('banner_image');
        $image_1_name_gen       =   hexdec(uniqid()) . '.' . $image_1_name->getClientOriginalExtension();
        $path           =   public_path('upload/go-online/' . $image_1_name_gen);
        Image::make($image_1_name->getRealPath())->save($path);
        $last_img       =   'upload/go-online/' . $image_1_name_gen;
        $data->banner_image            =   $last_img;
        //--------------------------------------
        if ($request->media_type == 'Image') {
            $image_name     =   $request->file('image');
            if ($image_name) {
                $name_gen       =   hexdec(uniqid()) . '.' . $image_name->getClientOriginalExtension();
                $path           =   public_path('upload/go-online/' . $name_gen);
                Image::make($image_name->getRealPath())->save($path);
                $last_img       =   'upload/go-online/' . $name_gen;
                $data->image            =   $last_img;
            } else {
                $notification = array(
                    'message' => 'Please Upload Image',
                    'alert-type' => 'warning'
                );
                return redirect()->back()->with($notification);
            }
        } elseif ($request->media_type == 'Video') {
            if ($request->video_type == 'MP4') {
                $video = $request->file('video');
                $thumbnail_image_name     =   $request->file('thumbnail_image');
                if (!empty($video) && $video != null && $thumbnail_image_name) {
                    $fileExentsion              = $video->extension();
                    $fileName                   = $video->getClientOriginalName();
                    $fileFullName               = time() . "_" . $fileName;
                    $path                       = Str::slug($fileFullName) . "." . $fileExentsion;
                    $video->move(public_path('upload/go-online/'), $path);
                    $fullpath                   = 'upload/go-online/' . $path;
                    $data->video            =   $fullpath;

                    //thumbnail_image
                    $thumbnail_image_name_gen       =   hexdec(uniqid()) . '.' . $thumbnail_image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/go-online/' . $thumbnail_image_name_gen);
                    Image::make($thumbnail_image_name->getRealPath())->save($path);
                    $last_img       =   'upload/go-online/' . $thumbnail_image_name_gen;
                    $data->thumbnail_image            =   $last_img;
                } else {
                    $notification = array(
                        'message' => 'Please Upload Video and thumbnail image',
                        'alert-type' => 'warning'
                    );
                    return redirect()->back()->with($notification);
                }
            } elseif ($request->video_type == 'Youtube' && $request->youtube) {
                $data->youtube            =   $request->youtube;
            } else {
                $notification = array(
                    'message' => 'Please Enter Youtube Link',
                    'alert-type' => 'warning'
                );
                return redirect()->back()->with($notification);
            }
        }

        $data->title       =   $request->title;
        $data->sub_title     =   $request->sub_title;
        if ($request->language == 'en') {
            $data->slug        =   trim(strtolower($request->slug));
        } else {
            $data->default_language_page = $request->default_language_page;
        }
        $data->description =   $request->description;

        $data->title_2 =   $request->title_2;
        $data->button_text =   $request->button_text;
        $data->button_link =   $request->button_link;
        $data->text_1 =   $request->text_1;
        $data->text_2 =   $request->text_2;

        $data->language         =   $request->language;
        $data->media_type         =   $request->media_type;
        $data->video_type         =   $request->video_type;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->created_by       =   Auth::user()->id;

        $result = $data->save();
        if (@$result) {
            $notification = array(
                'message' => 'Record Created Successfully!!',
                'alert-type' => 'success'
            );
            return redirect()->route('go-online.create-website.list')->with($notification);
        } else {
            $notification = array(
                'message' => 'Unable to save the data, Please try again later!!',
                'alert-type' => 'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data       =   GoOnlineCreateWebsite::find($id);
        return view('backend.page.go-online.create-website.view', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages  = Language::all();
        $data       =   GoOnlineCreateWebsite::find($id);
        $defaultLanguagePagesList = GoOnlineCreateWebsite::where('language', 'en')->where('status', 'Published')->get();
        return view('backend.page.go-online.create-website.edit', compact('data', 'languages', 'defaultLanguagePagesList'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'banner_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'video' => 'nullable|mimes:mp4,mov,ogg,qt',
            'thumbnail_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'title' => 'required',
            'description' => 'required',
            'title_2' => 'required',
            'media_type' => 'required',
            'button_text' => 'required',
            'button_link' => 'required',
            'text_1' => 'required',
            'text_2' => 'required',
            'language' => 'required',
            'meta_key' => 'required',
            'meta_title' => 'required',
            'meta_description' => 'required',
            'media_type' => 'required',
            'status' => 'required',
        ]);
        if ($request->language != 'en') {
            $check_data = GoOnlineCreateWebsite::where('id', '!=', $id)->where('default_language_page', $request->default_language_page)->where('language', $request->language)->count();
            if ($check_data) {
                $notification = array(
                    'message' => 'Title already exists!!.',
                    'alert-type' => 'warning'
                );
                return redirect()->back()->with($notification);
            }
        }

        $old_video = $request->old_video;
        $old_banner_image = $request->old_banner_image;
        $old_image = $request->old_image;
        $old_thumbnail_image = $request->old_thumbnail_image;

        $data = GoOnlineCreateWebsite::find($id);
        //--------------------------------------
        $image_1_name     =   $request->file('banner_image');
        if ($image_1_name) {
            $image_1_name_gen       =   hexdec(uniqid()) . '.' . $image_1_name->getClientOriginalExtension();
            $path           =   public_path('upload/go-online/' . $image_1_name_gen);
            Image::make($image_1_name->getRealPath())->save($path);
            $last_img       =   'upload/go-online/' . $image_1_name_gen;
            $data->banner_image            =   $last_img;
            if ($old_banner_image) {
                $unlink = @unlink($old_banner_image);
            }
        }
        //--------------------------------------
        $thumbnail_image_name     =   $request->file('thumbnail_image');
        if ($thumbnail_image_name) {
            $thumbnail_image_name_gen       =   hexdec(uniqid()) . '.' . $thumbnail_image_name->getClientOriginalExtension();
            $path           =   public_path('upload/go-online/' . $thumbnail_image_name_gen);
            Image::make($thumbnail_image_name->getRealPath())->save($path);
            $last_img       =   'upload/go-online/' . $thumbnail_image_name_gen;
            $data->thumbnail_image            =   $last_img;
            if ($old_thumbnail_image) {
                $unlink = @unlink($old_thumbnail_image);
            }
        }
        // ---------------------------------------------------------------------------------------------------
        if ($request->media_type == 'Image') {
            $image_name     =   $request->file('image');
            if ($image_name || $old_image) {
                if ($image_name) {
                    $name_gen       =   hexdec(uniqid()) . '.' . $image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/go-online/' . $name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/go-online/' . $name_gen;
                    $data->image            =   $last_img;
                    if ($old_image) {
                        $unlink = @unlink($old_image);
                    }
                }
            } else {
                $notification = array(
                    'message' => 'Please Upload Image',
                    'alert-type' => 'warning'
                );
                return redirect()->back()->with($notification);
            }
        } elseif ($request->media_type == 'Video') {
            if ($request->video_type == 'MP4') {
                $video = $request->file('video');
                if ((!empty($video) && $video != null) || $old_video) {
                    if (!empty($video) && $video != null) {
                        $fileExentsion              = $video->extension();
                        $fileName                   = $video->getClientOriginalName();
                        $fileFullName               = time() . "_" . $fileName;
                        $path                       = Str::slug($fileFullName) . "." . $fileExentsion;
                        $video->move(public_path('upload/go-online/'), $path);
                        $fullpath                   = 'upload/go-online/' . $path;
                        $data->video            =   $fullpath;
                        if ($old_video) {
                            $unlink = @unlink($old_video);
                        }
                    }
                } else {
                    $notification = array(
                        'message' => 'Please Upload Video',
                        'alert-type' => 'warning'
                    );
                    return redirect()->back()->with($notification);
                }
            } elseif ($request->video_type == 'Youtube' && $request->youtube) {
                $data->youtube            =   $request->youtube;
            } else {
                $notification = array(
                    'message' => 'Please Enter Youtube Link',
                    'alert-type' => 'warning'
                );
                return redirect()->back()->with($notification);
            }
        }
        // ---------------------------------------------------------------------------------------------------
        if ($request->language != 'en') {
            $data->default_language_page = $request->default_language_page;
        }
        $data->title       =   $request->title;
        $data->sub_title     =   $request->sub_title;
        $data->description =   $request->description;

        $data->title_2 =   $request->title_2;
        $data->button_text =   $request->button_text;
        $data->button_link =   $request->button_link;
        $data->text_1 =   $request->text_1;
        $data->text_2 =   $request->text_2;

        $data->language         =   $request->language;
        $data->media_type         =   $request->media_type;
        $data->video_type         =   $request->video_type;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->status         =   $request->status;
        $data->updated_by = Auth::user()->id;
        $result = $data->update();

        if ($result) {
            $notification = array(
                'message' => 'Record Update Successfully!!',
                'alert-type' => 'success'
            );
            return redirect()->route('go-online.create-website.list')->with($notification);
        } else {
            $notification = array(
                'message' => 'Unable to save the data, Please try again later!!',
                'alert-type' => 'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   GoOnlineCreateWebsite::find($id);
        if ($data->status == 'Trash') {
            $dataCheck = GoOnlineCreateWebsiteFeatures::where('go_online_create_website_id', $id)->count();
            $dataCheck1 = GoOnlineCreateWebsiteTheme::where('go_online_create_website_id', $id)->count();
            if ($dataCheck == 0 && $dataCheck1 == 0) {
                $result = $data->delete();
            } else {
                $notification = array(
                    'message' => 'First delete associated Category!!',
                    'alert-type' => 'warning'
                );
                return redirect()->back()->with($notification);
            }
        } else {
            $data->status = 'Trash';
            $result = $data->update();
        }
        if ($result) {
            $notification = array(
                'message' => 'Record Delete Successfully!!',
                'alert-type' => 'success'
            );
            return redirect()->back()->with($notification);
        } else {
            $notification = array(
                'message' => 'Unable to save the data, Please try again later!!',
                'alert-type' => 'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
