<?php

namespace App\Http\Controllers\backend\page\go_online;

use App\Http\Controllers\Controller;
use App\Models\GoOnlineDigitalMarketingServicesBenefits;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class GoOnlineDigitalMarketingServicesBenefitsController extends Controller
{
    public function edit($id)
    {
        $datas=GoOnlineDigitalMarketingServicesBenefits::where('digital_marketing_service_id',$id)->get();
        return view('backend.page.go-online.digital-marketing-services.benefits',compact('datas','id'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'title.*'=>'required',
            'link.*'=>'required'
        ]);
        GoOnlineDigitalMarketingServicesBenefits::where('digital_marketing_service_id',$id)->delete();
        $link=$request->link;
        foreach ($request->title as $key =>$value){
            $data    =   new GoOnlineDigitalMarketingServicesBenefits();
            $data->digital_marketing_service_id=$id;
            $data->title=$value;
            $data->link=$link[$key];
            $data->created_by=Auth::user()->id;
            $result=$data->save();
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('go-online.digital-marketing-services.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

}
