<?php

namespace App\Http\Controllers\backend\page\go_online;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\GoOnlineDigitalMarketingServices;
use App\Models\GoOnlineDigitalMarketingServicesFeatures;
use App\Models\GoOnlineDigitalMarketingServicesBenefits;
use App\Models\Language;
use Intervention\Image\Facades\Image;
use Str;

class GoOnlineDigitalMarketingServicesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas=GoOnlineDigitalMarketingServices::all();
        return view('backend.page.go-online.digital-marketing-services.index',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages  =Language::all();
        $defaultLanguagePagesList=GoOnlineDigitalMarketingServices::where('language','en')->where('status','Published')->get();
        return view('backend.page.go-online.digital-marketing-services.add',compact('languages','defaultLanguagePagesList'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image_1'=>'required|image|mimes:jpeg,png,jpg,gif,svg',
            'image_2'=>'required|image|mimes:jpeg,png,jpg,gif,svg',
            'image_3'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'benefits_background_image'=>'required|image|mimes:jpeg,png,jpg,gif,svg',
            'thumbnail_image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'video'=>'nullable|mimes:mp4,mov,ogg,qt',
            'title'=>'required',
            'sub_title'=>'required',
            'description'=>'required',
            'global_presence_title'=>'required',
            'global_presence_1'=>'required',
            'global_presence_2'=>'required',
            'global_presence_3'=>'required',
            'global_presence_4'=>'required',
            'global_presence_5'=>'required',
            'media_type'=>'required',
            'features_text'=>'required',
            'benefits_text'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
            'media_type'=>'required',
        ]);
        if($request->language =='en' && $request->slug){
            $check_data=GoOnlineDigitalMarketingServices::where('slug',$request->slug)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->language !='en' && $request->default_language_page){
            $check_data=GoOnlineDigitalMarketingServices::where('default_language_page',$request->default_language_page)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $notification=array(
                'message'=>'Please first add english language page!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    =   new GoOnlineDigitalMarketingServices();
        //--------------------------------------
        $image_1_name     =   $request->file('image_1');
        $image_1_name_gen       =   hexdec(uniqid()).'.'.$image_1_name->getClientOriginalExtension();
        $path           =   public_path('upload/go-online/'.$image_1_name_gen);
        Image::make($image_1_name->getRealPath())->save($path);
        $last_img       =   'upload/go-online/'.$image_1_name_gen;
        $data->image_1            =   $last_img;
        //--------------------------------------
        $benefits_background_image_name     =   $request->file('benefits_background_image');
        $benefits_background_image_name_gen       =   hexdec(uniqid()).'.'.$benefits_background_image_name->getClientOriginalExtension();
        $path           =   public_path('upload/go-online/'.$benefits_background_image_name_gen);
        Image::make($image_1_name->getRealPath())->save($path);
        $last_img       =   'upload/go-online/'.$benefits_background_image_name_gen;
        $data->benefits_background_image            =   $last_img;
        //--------------------------------------
        $image_2_name     =   $request->file('image_2');
        $image_2_name_gen       =   hexdec(uniqid()).'.'.$image_2_name->getClientOriginalExtension();
        $path           =   public_path('upload/go-online/'.$image_2_name_gen);
        Image::make($image_2_name->getRealPath())->save($path);
        $last_img       =   'upload/go-online/'.$image_2_name_gen;
        $data->image_2            =   $last_img;
        //--------------------------------------
        if($request->media_type=='Image'){
            $image_name     =   $request->file('image_3');
            if($image_name){
                $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                $path           =   public_path('upload/go-online/'.$name_gen);
                Image::make($image_name->getRealPath())->save($path);
                $last_img       =   'upload/go-online/'.$name_gen;
                $data->image_3            =   $last_img;
            }else{
                $notification=array(
                    'message'=>'Please Upload Image',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->media_type=='Video'){
            if($request->video_type=='MP4'){
                $video = $request->file('video');
                $thumbnail_image_name     =   $request->file('thumbnail_image');
                if(!empty($video) && $video != null && $thumbnail_image_name){
                    $fileExentsion              = $video->extension();
                    $fileName                   = $video->getClientOriginalName();
                    $fileFullName               = time()."_".$fileName;
                    $path                       = Str::slug($fileFullName).".".$fileExentsion;
                    $video->move(public_path('upload/go-online/'), $path);
                    $fullpath                   = 'upload/go-online/'.$path;
                    $data->video            =   $fullpath;
                    //thumbnail_image
                    $thumbnail_image_name_gen       =   hexdec(uniqid()).'.'.$thumbnail_image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/go-online/'.$thumbnail_image_name_gen);
                    Image::make($thumbnail_image_name->getRealPath())->save($path);
                    $last_img       =   'upload/go-online/'.$thumbnail_image_name_gen;
                    $data->thumbnail_image            =   $last_img;
                }else{
                    $notification=array(
                        'message'=>'Please Upload Video and thumbnail image',
                        'alert-type'=>'warning'
                    );
                    return redirect()->back()->with($notification);
                }
            }elseif($request->video_type=='Youtube' && $request->youtube){
                $data->youtube            =   $request->youtube;
            }else{
                $notification=array(
                    'message'=>'Please Enter Youtube Link',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }

        $data->title       =   $request->title;
        $data->sub_title     =   $request->sub_title;
        if($request->language =='en'){
            $data->slug        =   trim(strtolower($request->slug));
        }else{
            $data->default_language_page = $request->default_language_page;
        }
        $data->description =   $request->description;

        $data->global_presence_title =   $request->global_presence_title;
        $data->global_presence_1 =   $request->global_presence_1;
        $data->global_presence_2 =   $request->global_presence_2;
        $data->global_presence_3 =   $request->global_presence_3;
        $data->global_presence_4 =   $request->global_presence_4;
        $data->global_presence_5 =   $request->global_presence_5;
        $data->features_text =   $request->features_text;
        $data->benefits_text =   $request->benefits_text;

        $data->language         =   $request->language;
        $data->media_type         =   $request->media_type;
        $data->video_type         =   $request->video_type;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->created_by       =   Auth::user()->id;

        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('go-online.digital-marketing-services.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data       =   GoOnlineDigitalMarketingServices::find($id);
        return view('backend.page.go-online.digital-marketing-services.view',compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages  =Language::all();
        $defaultLanguagePagesList=GoOnlineDigitalMarketingServices::where('language','en')->where('status','Published')->get();
        $data       =   GoOnlineDigitalMarketingServices::find($id);
        return view('backend.page.go-online.digital-marketing-services.edit',compact('data','languages','defaultLanguagePagesList'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'image_1'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'image_2'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'image_3'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'benefits_background_image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'thumbnail_image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'video'=>'nullable|mimes:mp4,mov,ogg,qt',
            'title'=>'required',
            'sub_title'=>'required',
            'description'=>'required',
            'global_presence_title'=>'required',
            'global_presence_1'=>'required',
            'global_presence_2'=>'required',
            'global_presence_3'=>'required',
            'global_presence_4'=>'required',
            'global_presence_5'=>'required',
            'media_type'=>'required',
            'features_text'=>'required',
            'benefits_text'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
            'status'=>'required',
        ]);

        if($request->language !='en'){
            $check_data=GoOnlineDigitalMarketingServices::where('id','!=',$id)->where('default_language_page',$request->default_language_page)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }
        $old_video=$request->old_video;
        $old_image_1=$request->old_image_1;
        $old_image_2=$request->old_image_2;
        $old_image_3=$request->old_image_3;
        $old_benefits_background_image=$request->old_benefits_background_image;
        $old_thumbnail_image=$request->old_thumbnail_image;

        $data= GoOnlineDigitalMarketingServices::find($id);
        //--------------------------------------
        $image_1_name     =   $request->file('image_1');
        if($image_1_name){
            $image_1_name_gen       =   hexdec(uniqid()).'.'.$image_1_name->getClientOriginalExtension();
            $path           =   public_path('upload/go-online/'.$image_1_name_gen);
            Image::make($image_1_name->getRealPath())->save($path);
            $last_img       =   'upload/go-online/'.$image_1_name_gen;
            $data->image_1            =   $last_img;
            if($old_image_1){
                $unlink=@unlink($old_image_1);
            }
        }
        //--------------------------------------
        $benefits_background_image_name     =   $request->file('benefits_background_image');
        if($benefits_background_image_name){
            $benefits_background_image_name_gen       =   hexdec(uniqid()).'.'.$benefits_background_image_name->getClientOriginalExtension();
            $path           =   public_path('upload/go-online/'.$benefits_background_image_name_gen);
            Image::make($benefits_background_image_name->getRealPath())->save($path);
            $last_img       =   'upload/go-online/'.$benefits_background_image_name_gen;
            $data->benefits_background_image            =   $last_img;
            if($old_benefits_background_image){
                $unlink=@unlink($old_benefits_background_image);
            }
        }
        //--------------------------------------
        $image_2_name     =   $request->file('image_2');
        if($image_2_name){
            $image_2_name_gen       =   hexdec(uniqid()).'.'.$image_2_name->getClientOriginalExtension();
            $path           =   public_path('upload/go-online/'.$image_2_name_gen);
            Image::make($image_2_name->getRealPath())->save($path);
            $last_img       =   'upload/go-online/'.$image_2_name_gen;
            $data->image_2            =   $last_img;
            if($old_image_2){
                $unlink=@unlink($old_image_2);
            }
        }
        //--------------------------------------
        $thumbnail_image_name     =   $request->file('thumbnail_image');
        if($thumbnail_image_name){
            $thumbnail_image_name_gen       =   hexdec(uniqid()).'.'.$thumbnail_image_name->getClientOriginalExtension();
            $path           =   public_path('upload/go-online/'.$thumbnail_image_name_gen);
            Image::make($thumbnail_image_name->getRealPath())->save($path);
            $last_img       =   'upload/go-online/'.$thumbnail_image_name_gen;
            $data->thumbnail_image            =   $last_img;
            if($old_thumbnail_image){
                $unlink=@unlink($old_thumbnail_image);
            }
        }
        // ---------------------------------------------------------------------------------------------------
        if($request->media_type=='Image'){
            $image_name     =   $request->file('image_3');
            if($image_name ||$old_image_3){
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/go-online/'.$name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/go-online/'.$name_gen;
                    $data->image_3            =   $last_img;
                    if($old_image_3){
                        $unlink=@unlink($old_image_3);
                    }
                }
            }else{
                $notification=array(
                    'message'=>'Please Upload Image',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->media_type=='Video'){
            if($request->video_type=='MP4'){
                $video = $request->file('video');
                if((!empty($video) && $video != null) ||$old_video){
                    if(!empty($video) && $video != null){
                        $fileExentsion              = $video->extension();
                        $fileName                   = $video->getClientOriginalName();
                        $fileFullName               = time()."_".$fileName;
                        $path                       = Str::slug($fileFullName).".".$fileExentsion;
                        $video->move(public_path('upload/go-online/'), $path);
                        $fullpath                   = 'upload/go-online/'.$path;
                        $data->video            =   $fullpath;
                        if($old_video){
                            $unlink=@unlink($old_video);
                        }
                    }
                }else{
                    $notification=array(
                        'message'=>'Please Upload Video',
                        'alert-type'=>'warning'
                    );
                    return redirect()->back()->with($notification);
                }
            }elseif($request->video_type=='Youtube' && $request->youtube){
                $data->youtube            =   $request->youtube;
            }else{
                $notification=array(
                    'message'=>'Please Enter Youtube Link',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }
        // ---------------------------------------------------------------------------------------------------

        $data->title       =   $request->title;
        $data->sub_title     =   $request->sub_title;
        $data->description =   $request->description;
        if($request->language !='en'){
            $data->default_language_page = $request->default_language_page;
        }
        $data->global_presence_title =   $request->global_presence_title;
        $data->global_presence_1 =   $request->global_presence_1;
        $data->global_presence_2 =   $request->global_presence_2;
        $data->global_presence_3 =   $request->global_presence_3;
        $data->global_presence_4 =   $request->global_presence_4;
        $data->global_presence_5 =   $request->global_presence_5;
        $data->features_text =   $request->features_text;
        $data->benefits_text =   $request->benefits_text;

        $data->language         =   $request->language;
        $data->media_type         =   $request->media_type;
        $data->video_type         =   $request->video_type;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->status         =   $request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('go-online.digital-marketing-services.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   GoOnlineDigitalMarketingServices::find($id);
        if($data->status=='Trash'){
            $dataCheck=GoOnlineDigitalMarketingServicesFeatures::where('digital_marketing_service_id',$id)->count();
            $dataCheck1=GoOnlineDigitalMarketingServicesBenefits::where('digital_marketing_service_id',$id)->count();
            if($dataCheck==0 && $dataCheck1==0){
                $result=$data->delete();
            }else{
                $notification=array(
                    'message'=>'First delete associated Category!!',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
