<?php

namespace App\Http\Controllers\backend\page\home;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\HomeCloud;
use App\Models\Language;
use Intervention\Image\Facades\Image;

class HomeCloudController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas=HomeCloud::all();
        return view('backend.page.home.cloud.index',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages  = Language::all();
        return view('backend.page.home.cloud.add',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image'=>'nullable|mimes:jpg,png,jpeg,gif,svg',
            'number'=>'required',
            'text'=>'required',
            'language'=>'required',
        ]);

        $data    =   new HomeCloud();

        //--------------------------------------
        $image_name     =   $request->file('image');
        if($image_name){
            $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
            $path           =   public_path('upload/home/cloud/'.$name_gen);
            Image::make($image_name->getRealPath())->save($path);
            $last_img       =   'upload/home/cloud/'.$name_gen;
            $data->image            =   $last_img;
        }
        //-----------------------------------------

        $data->number=$request->number;
        $data->text=$request->text;
        $data->language=$request->language;
        $data->created_by=Auth::user()->id;
        $result=$data->save();

        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.cloud.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data       =   HomeCloud::find($id);
        return view('backend.page.home.cloud.view',compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages  = Language::all();
        $data       =   HomeCloud::find($id);
        return view('backend.page.home.cloud.edit',compact('data','languages'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'image'=>'nullable|mimes:jpg,png,jpeg,gif,svg',
            'number'=>'required',
            'text'=>'required',
            'language'=>'required',
        ]);
        $old_image=$request->old_image;

        $data= HomeCloud::find($id);
        //--------------------------------------
        $image_name     =   $request->file('image');
        if($image_name){
            $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
            $path           =   public_path('upload/home/cloud/'.$name_gen);
            Image::make($image_name->getRealPath())->save($path);
            $last_img       =   'upload/home/cloud/'.$name_gen;
            $data->image            =   $last_img;
            if($old_image){
                $unlink=@unlink($old_image);
            }
        }
        //-----------------------------------------
        $data->number=$request->number;
        $data->text=$request->text;
        $data->language=$request->language;
        $data->status=$request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Updated Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.cloud.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   HomeCloud::find($id);
        if($data->status=='Trash'){
            $result=$data->delete();
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.cloud.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
