<?php

namespace App\Http\Controllers\backend\page\home;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HomeIndustries;
use App\Models\Language;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Auth;

class HomeIndustriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas=HomeIndustries::all();
        return view('backend.page.home.industries.index',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages  = Language::all();
        return view('backend.page.home.industries.add',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image'=>'required|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'description'=>'required',
            'button_text'=>'required',
            'button_link'=>'required|url',
            'language'=>'required',
        ]);
        $checkData=HomeIndustries::where('status','Published')->where('language',$request->language)->count();
        if($checkData>=7){
            $notification=array(
                'message'=>'7 Industries add in one language!!',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }
        $data    =   new HomeIndustries();

        //--------------------------------------
        $image_name     =   $request->file('image');
        $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
        $path           =   public_path('upload/home/industries/'.$name_gen);
        Image::make($image_name->getRealPath())->save($path);
        $last_img       =   'upload/home/industries/'.$name_gen;
        $data->image            =   $last_img;
        //--------------------------------------

        $data->title=$request->title;
        $data->description=$request->description;
        $data->button_text=$request->button_text;
        $data->button_link=$request->button_link;
        $data->language=$request->language;
        $data->created_by=Auth::user()->id;
        $result=$data->save();

        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.industries.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $languages  = Language::all();
        $data       =   HomeIndustries::find($id);
        return view('backend.page.home.industries.view',compact('data','languages'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages  = Language::all();
        $data       =   HomeIndustries::find($id);
        return view('backend.page.home.industries.edit',compact('data','languages'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'image'=>'nullable|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'description'=>'required',
            'button_text'=>'required',
            'button_link'=>'required|url',
            'language'=>'required',
        ]);
        $checkData=HomeIndustries::where('status','Published')->where('language',$request->language)->count();
        if($checkData>7){
            $notification=array(
                'message'=>'7 Industries add in one language!!',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $old_image=$request->old_image;

        $data= HomeIndustries::find($id);


        //--------------------------------------
        $image_name     =   $request->file('image');
        if($image_name){
            $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
            $path           =   public_path('upload/home/industries/'.$name_gen);
            Image::make($image_name->getRealPath())->save($path);
            $last_img       =   'upload/home/industries/'.$name_gen;
            $data->image            =   $last_img;
            if($old_image){
                $unlink=@unlink($old_image);
            }
        }
        //--------------------------------------

        $data->title=$request->title;
        $data->description=$request->description;
        $data->button_text=$request->button_text;
        $data->button_link=$request->button_link;
        $data->language=$request->language;
        $data->status=$request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Record Updated Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.industries.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   HomeIndustries::find($id);
        if($data->status=='Trash'){
            $result=$data->delete();
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.industries.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
