<?php

namespace App\Http\Controllers\backend\page\home;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HomeSlider;
use App\Models\HomeSliderChild;
use App\Models\Language;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class HomeSliderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas=HomeSlider::all();
        return view('backend.page.home.slider.index',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages  = Language::all();
        return view('backend.page.home.slider.add',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image'=>'required|mimes:jpg,png,jpeg,gif,svg',
            'icon'=>'required|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'description'=>'required',
            'text'=>'required',
            'language'=>'required',
        ]);
        try{
            $checkData=HomeSlider::where('status','Published')->where('language',$request->language)->count();
            if($checkData>=3){
                $notification=array(
                    'message'=>'Three Slider make in one language!!',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
            $data    =   new HomeSlider();

            //--------------------------------------
            $image_name     =   $request->file('image');
            $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
            $path           =   public_path('upload/home/slider/'.$name_gen);
            Image::make($image_name->getRealPath())->save($path);
            $last_img       =   'upload/home/slider/'.$name_gen;
            $data->image            =   $last_img;
            //--------------------------------------
            $icon_name     =   $request->file('icon');
            $name_gen1       =   hexdec(uniqid()).'.'.$icon_name->getClientOriginalExtension();
            $path           =   public_path('upload/home/slider/'.$name_gen1);
            Image::make($icon_name->getRealPath())->save($path);
            $last_icon       =   'upload/home/slider/'.$name_gen1;
            $data->icon            =   $last_icon;
            //-----------------------------------------

            $data->title=$request->title;
            $data->description=$request->description;
            $data->text=$request->text;
            $data->language=$request->language;
            $data->created_by=Auth::user()->id;
            $result=$data->save();

            $parent_id=$data->id;
            $child_title=$request->child_title;
            $child_link=$request->child_link;
            if($child_title && $child_link){
                foreach($child_title as $key => $title){
                    $child=new HomeSliderChild();
                    $child->home_slider_id = $parent_id;
                    $child->button_text = $child_title[$key];
                    $child->button_link = $child_link[$key];
                    $child->save();
                }
            }
            if($result){
                $notification=array(
                    'message'=>'Record Created Successfully!!',
                    'alert-type'=>'success'
                );
                return redirect()->route('home.slider.list')->with($notification);
            }else{
                $notification=array(
                    'message'=>'Unable to save the data, Please try again later!!',
                    'alert-type'=>'error'
                );
                return redirect()->back()->with($notification);
            }
        }catch(\Exception $e){
            Log::error('Slider Home Page: '.$e);
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $languages  = Language::all();
        $data       =   HomeSlider::find($id);
        return view('backend.page.home.slider.view',compact('data','languages'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages  = Language::all();
        $data       =   HomeSlider::find($id);
        return view('backend.page.home.slider.edit',compact('data','languages'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'image'=>'nullable|mimes:jpg,png,jpeg,gif,svg',
            'icon'=>'nullable|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'description'=>'required',
            'text'=>'required',
            'language'=>'required',
        ]);
        $checkData=HomeSlider::where('status','Published')->where('language',$request->language)->count();
        if($checkData>3){
            $notification=array(
                'message'=>'Three Slider make in one language!!',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $old_image=$request->old_image;
        $old_icon=$request->old_icon;

        $data= HomeSlider::find($id);


        //--------------------------------------
        $image_name     =   $request->file('image');
        if($image_name){
            $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
            $path           =   public_path('upload/home/slider/'.$name_gen);
            Image::make($image_name->getRealPath())->resize(1920,1000)->save($path);
            $last_img       =   'upload/home/slider/'.$name_gen;
            $data->image            =   $last_img;
            if($old_image){
                $unlink=@unlink($old_image);
            }
        }
        //--------------------------------------
        $icon_name     =   $request->file('icon');
        if($icon_name){
            $name_gen1       =   hexdec(uniqid()).'.'.$icon_name->getClientOriginalExtension();
            $path           =   public_path('upload/home/slider/'.$name_gen1);
            Image::make($icon_name->getRealPath())->resize(92,118)->save($path);
            $last_icon       =   'upload/home/slider/'.$name_gen1;
            $data->icon            =   $last_icon;
            if($old_icon){
                $unlink=@unlink($old_icon);
            }
        }
        //-----------------------------------------
        $data->title=$request->title;
        $data->description=$request->description;
        $data->text=$request->text;
        $data->language=$request->language;
        $data->status=$request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->save();

        //child
        HomeSliderChild::where('home_slider_id',$id)->delete();
        $parent_id=$data->id;
        $child_title=$request->child_title;
        $child_link=$request->child_link;
        if($child_title && $child_link){
            foreach($child_title as $key => $title){
                $child=new HomeSliderChild();
                $child->home_slider_id = $parent_id;
                $child->button_text = $child_title[$key];
                $child->button_link = $child_link[$key];
                $child->save();
            }
        }

        if($result){
            $notification=array(
                'message'=>'Record Updated Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.slider.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   HomeSlider::find($id);
        if($data->status=='Trash'){
            HomeSliderChild::where('home_slider_id',$id)->delete();
            $result=$data->delete();
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.slider.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
