<?php

namespace App\Http\Controllers\backend\page\industries;

use App\Http\Controllers\Controller;
use App\Models\Industries;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\IndustriesCategory;
use App\Models\Language;

class IndustriesCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas=IndustriesCategory::all();
        return view('backend.page.industries.category.index',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages  =Language::all();
        $defaultLanguagePagesList=IndustriesCategory::where('language','en')->where('status','Published')->get();
        return view('backend.page.industries.category.add',compact('languages','defaultLanguagePagesList'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
        ]);

        if($request->language =='en' && $request->slug){
            $check_data=IndustriesCategory::where('slug',$request->slug)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->language !='en' && $request->default_language_page){
            $check_data=IndustriesCategory::where('default_language_page',$request->default_language_page)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $notification=array(
                'message'=>'Please first add english language page!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    =   new IndustriesCategory();
        $data->name       =   $request->name;
        if($request->language =='en'){
            $data->slug        =   trim(strtolower($request->slug));
        }else{
            $data->default_language_page = $request->default_language_page;
        }
        $data->language         =   $request->language;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->created_by = Auth::user()->id;
        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('industries.category.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data       =   IndustriesCategory::find($id);
        return view('backend.page.industries.category.view',compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages  =Language::all();
        $defaultLanguagePagesList=IndustriesCategory::where('language','en')->where('status','Published')->get();
        $data       =   IndustriesCategory::find($id);
        return view('backend.page.industries.category.edit',compact('data','languages','defaultLanguagePagesList'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
            'status'=>'required',
        ]);

        if ($request->language != 'en') {
            $check_data = IndustriesCategory::where('id', '!=', $id)->where('default_language_page', $request->default_language_page)->where('language', $request->language)->count();
            if ($check_data) {
                $notification = array(
                    'message' => 'Title already exists!!.',
                    'alert-type' => 'warning'
                );
                return redirect()->back()->with($notification);
            }
        }
        $data= IndustriesCategory::find($id);
        $data->name       =   $request->name;
        if ($request->language != 'en') {
            $data->default_language_page = $request->default_language_page;
        }
        $data->meta_key       =   $request->meta_key;
        $data->meta_title       =   $request->meta_title;
        $data->meta_description       =   $request->meta_description;
        $data->language       =   $request->language;
        $data->status       =   $request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();
        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('industries.category.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   IndustriesCategory::find($id);
        if($data->status=='Trash'){
            $dataCheck=Industries::where('industries_category_id',$id)->count();
            if($dataCheck==0){
                $result=$data->delete();
            }else{
                $notification=array(
                    'message'=>'First delete associated Category!!',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('industries.category.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
