<?php

namespace App\Http\Controllers\backend\setting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Currency;
use Illuminate\Support\Facades\Auth;

class CurrencyController extends Controller
{
    public function index(){
        $datas=Currency::all();
        return view('backend.setting.currency.index',compact('datas'));
    }

    public function edit($id)
    {
        $data       =   Currency::find($id);
        return view('backend.setting.currency.edit',compact('data'));
    }

    public function update(Request $request, $id){
        $request->validate([
            'rate'=>'required |numeric',
        ]);

        $data= Currency::find($id);
        $data->rate       =   $request->rate;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.currency.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

}
