<?php

namespace App\Http\Controllers\backend\setting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\GST;
use Illuminate\Support\Facades\Auth;

class GSTController extends Controller
{
    public function index(){
        $datas=GST::all();
        return view('backend.setting.gst.index',compact('datas'));
    }

    public function update(Request $request){
        $request->validate([
            'rate'=>'required |numeric|min:0',
        ]);

        $data= GST::find($request->id);
        $data->rate       =   $request->rate;
        $data->tax_name   =   $request->tax_name;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.gst.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
