<?php

namespace App\Http\Controllers\backend\setting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\PaymentGatewayKey;

class PaymentGatewayKeyManagementController extends Controller
{
    public function index(){
        $datas=PaymentGatewayKey::all();
        return view('backend.setting.payment-gateway.index',compact('datas'));
    }

    public function update(Request $request){
        $request->validate([
            'apikey'=>'required',
            'accesskey'=>'required',
            'secretkey'=>'required',
        ]);

        $data= PaymentGatewayKey::find($request->id);
        $data->apikey       =   $request->apikey;
        $data->accesskey       =   $request->accesskey;
        $data->secretkey       =   $request->secretkey;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
