<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Providers\HelperServiceProvider;
use App\Models\FinancialServices;
use App\Models\FinancialServicesService;
use App\Models\FinancialServicesCard;
use App\Models\FinancialServiceBusinessPaymentPlatforms;

class FinancialServicesPageController extends Controller
{
    public function FinancialService($slug){
        try{
            $language=HelperServiceProvider::DefaultLanguage();
            $financial_service=FinancialServices::where('slug',$slug)->where('status','Published')->where('language','en')->first();
            if($financial_service){
                if($language !='en'){
                    $financial_serviceCheck=FinancialServices::where('default_language_page',$financial_service->id)->where('status','Published')->where('language',$language)->first();
                    $financial_service=$financial_serviceCheck?$financial_serviceCheck:$financial_service;
                }
                $financial_service_card=FinancialServicesCard::where('financial_service_id',$financial_service->id)->get();
                $financial_service_service=FinancialServicesService::where('financial_service_id',$financial_service->id)->get();
                return view('frontend.user.financial-service.payment-gateway',compact('financial_service','financial_service_card','financial_service_service'));
            }else{
                $financial_service=FinancialServiceBusinessPaymentPlatforms::where('slug',$slug)->where('status','Published')->where('language','en')->first();
                if($financial_service){
                    if($language !='en'){
                        $financial_serviceCheck=FinancialServiceBusinessPaymentPlatforms::where('default_language_page',$financial_service->id)->where('status','Published')->where('language',$language)->first();
                        $financial_service=$financial_serviceCheck?$financial_serviceCheck:$financial_service;
                    }
                    return view('frontend.user.financial-service.business-payment-platforms',compact('financial_service'));
                }else{
                    return redirect()->back();
                }
            }
        }catch(\Exception $e){
            return redirect()->back();
        }
    }
}
