<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Providers\HelperServiceProvider;
use App\Models\GoOnlineCreateWebsite;
use App\Models\GoOnlineCreateWebsiteFeatures;
use App\Models\GoOnlineCreateWebsiteTheme;
use App\Models\GoOnlineDigitalMarketingServices;
use App\Models\GoOnlineDigitalMarketingServicesBenefits;
use App\Models\GoOnlineDigitalMarketingServicesFeatures;

class GoOnlinePageController extends Controller
{
    public function GoOnline($slug){
        try{
            $language=HelperServiceProvider::DefaultLanguage();
            $go_online=GoOnlineCreateWebsite::where('slug',$slug)->where('status','Published')->where('language','en')->first();
            if($go_online){
                if($language !='en'){
                    $go_onlineCheck=GoOnlineCreateWebsite::where('default_language_page',$go_online->id)->where('status','Published')->where('language',$language)->first();
                    $go_online=$go_onlineCheck?$go_onlineCheck:$go_online;
                }
                $features=GoOnlineCreateWebsiteFeatures::where('go_online_create_website_id',$go_online->id)->get();
                $themes=GoOnlineCreateWebsiteTheme::where('go_online_create_website_id',$go_online->id)->get();
                return view('frontend.user.go-online.create-website',compact('go_online','themes','features'));
            }else{
                $go_online=GoOnlineDigitalMarketingServices::where('slug',$slug)->where('status','Published')->where('language','en')->first();
                if($go_online){
                    if($language !='en'){
                        $go_onlineCheck=GoOnlineDigitalMarketingServices::where('default_language_page',$go_online->id)->where('status','Published')->where('language',$language)->first();
                        $go_online=$go_onlineCheck?$go_onlineCheck:$go_online;
                    }
                    $features=GoOnlineDigitalMarketingServicesFeatures::where('digital_marketing_service_id',$go_online->id)->get();
                    $benefits=GoOnlineDigitalMarketingServicesBenefits::where('digital_marketing_service_id',$go_online->id)->get();
                    return view('frontend.user.go-online.digital-marketing-services',compact('go_online','benefits','features'));
                }else{
                    return redirect()->back();
                }
            }
        }catch(\Exception $e){
            return redirect()->back();
        }
    }
}
