<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Providers\HelperServiceProvider;
use App\Models\Industries;
use App\Models\IndustriesKeyOfferings;
use App\Models\IndustriesService;

class IndustryPageController extends Controller
{
    public function Industry($slug){
        try{
            $language=HelperServiceProvider::DefaultLanguage();
            $industries=Industries::where('slug',$slug)->where('status','Published')->where('language','en')->first();
            if($industries){
                $industriesNew=Industries::where('default_language_page',$industries->id)->where('status','Published')->where('language',$language)->first();
                $industries = ($industriesNew)?$industriesNew:$industries;
                if($industries){
                    $industries_key_offerings=IndustriesKeyOfferings::where('industries_id',$industries->id)->get();
                    $industries_service=IndustriesService::where('industries_id',$industries->id)->limit(9)->get();
                    return view('frontend.user.industry',compact('industries','industries_key_offerings','industries_service'));
                }
            }
            return redirect()->back();
        }catch(\Exception $e){
            return redirect()->back();
        }
    }
}
