<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Providers\HelperServiceProvider;
use App\Models\BlogCategory;
use App\Models\PostComment;
use App\Models\PostLike;
use App\Models\Notification;
use App\Models\Posts;
use Illuminate\Support\Facades\Auth;
use App\Providers\MessageManagementProvider;
use Carbon\Carbon;

class PostPageController extends Controller
{
    public function List(Request $request){
        try{
            $language=HelperServiceProvider::DefaultLanguage();
            if(@$request->order=='asc'){
                $datas=Posts::where('post_type','post')->where('post_status','Published')->where('language',$language)->orderBy('created_at', 'ASC')->limit(10)->get();
            }else{
                $datas=Posts::where('post_type','post')->where('post_status','Published')->where('language',$language)->orderBy('created_at', 'DESC')->limit(10)->get();
            }
            $countPost=Posts::where('post_type','post')->where('post_status','Published')->where('language',$language)->count();
            if(!$datas->isEmpty()){
                return view('frontend.user.post.list',compact('datas','countPost'));
            }else{
                return redirect()->back();
            }
        }catch(\Exception $e){
            return redirect()->back();
        }
    }

    public function Single($slug){
        try{
            $language=HelperServiceProvider::DefaultLanguage();
            $data=Posts::where('post_type','post')->where('post_status','Published')->where('language','en')->where('post_slug',$slug)->first();
            $data->total_post_view=$data->total_post_view+1;
            $data->save();
            $commentList=PostComment::where('post_id',$data->id)->where('status','1')->get();
            $comments=array();
            if(@$commentList){
                $i=0;
                foreach($commentList as $comment){
                    // $commentTime = Carbon::createFromTimestamp($comment->created_at);
                    $commentTime = Carbon::createFromTimestamp(strtotime($comment->created_at));
                    $time = '';

                    // Check if it's within the past hour
                    if ($commentTime->isToday()) {
                        $time = $commentTime->diffForHumans();
                    }
                    // Check if it's within the past week
                    elseif ($commentTime->isLastWeek()) {
                        $time = $commentTime->format('l');
                    }
                    // Return the full date for older comments
                    else {
                        $time = $commentTime->format('F j, Y');
                    }
                    //
                    $comments[$i]['name']=$comment->name;
                    $comments[$i]['time']=$time;
                    $comments[$i]['comment']=$comment->comment;
                    $i++;
                }
            }
            $dataNew=Posts::where('post_type','post')->where('post_status','Published')->where('language',$language)->where('default_language_page',$data->id)->first();
            if($dataNew){
                $dataNew->total_post_view=$data->total_post_view;
                $dataNew->save();
            }
            $data=($dataNew)?$dataNew:$data;
            $datas=Posts::where('id','!=',$data->id)->where('post_type','post')->where('post_status','Published')->where('language',$language)->orderBy('id', 'DESC')->limit(2)->get();
            if($data){
                return view('frontend.user.post.single',compact('data','datas','comments'));
            }else{
                return redirect()->back();
            }
        }catch(\Exception $e){
            return redirect()->back();
        }
    }

    Public function ListAjax(Request $request){
        try{
            $language=HelperServiceProvider::DefaultLanguage();
            if(@$request->order=='asc'){
                $datas=Posts::where('post_type','post')->where('post_status','Published')->where('language',$language)->orderBy('created_at', 'ASC')->skip($request->no_of_row)->take(2)->get();
            }else{
                $datas=Posts::where('post_type','post')->where('post_status','Published')->where('language',$language)->orderBy('created_at', 'DESC')->skip($request->no_of_row)->take(2)->get();
            }
            if($datas){
                $list=array();
                foreach($datas as $data){
                    $child=array();
                    $child['title']=$data->post_title;
                    $child['date']=date('F d, Y',strtotime($data->created_at));

                    if ($data->language!='en' && $data->default_language_page && @$data['DefaultLanguagePage']['post_slug']){
                        $child['link']=route('post.page.single', $data['DefaultLanguagePage']['post_slug']);
                    }elseif($data->post_slug){
                        $child['link']=route('post.page.single', $data->post_slug);
                    }else{
                        $child['link']='';
                    }

                    $words = explode(" ", $data->post_content);
                    if (count($words) > 20) {
                        $limitedWords = array_slice($words, 0, 20);
                        $limitedSentence = implode(" ", $limitedWords) . "...";
                    } else {
                        $limitedSentence = $data->post_content;
                    }
                    $child['description']=$limitedSentence;
                    $list[]=$child;
                }
                return $list;
            }else{
                return ;
            }
        }catch(\Exception $e){
            return ;
        }
    }

    public function addRemoveLike(Request $request){
        try{
            if($request->like==1){
                PostLike::where('post_id', $request->id)->where('user_id', Auth::user()->id)->delete();

                $data=new PostLike();
                $data->user_id=Auth::user()->id;
                $data->post_id=$request->id;
                $data->save();
            }else{
                $data=PostLike::where('post_id', $request->id)->where('user_id', Auth::user()->id)->delete();
            }
            //count like
            return PostLike::where('post_id', $request->id)->count();
        }catch(\Exception $e){
            return;
        }
    }

    public function commentStore(Request $request){
        try{
            $data=new PostComment();
            $data->name = (Auth::check()) ? (Auth::user()->f_name . ' ' . Auth::user()->l_name) : 'Anonymous';
            $data->post_id=$request->token;
            $data->comment=$request->comment;
            $data->save();

            //admin notification
            $postData=Posts::find($request->token);
            $notification=new Notification();
            $name=(Auth::check()) ? (Auth::user()->f_name . ' ' . Auth::user()->l_name) : 'Anonymous';
            $notification->title= $name .' has comment on post';
            $notification->notification_from= '4';
            $notification->table_id= $request->token;
            $notification->description=$name.' comment on post '.@$postData->post_title;
            $notification->save();



            $message=MessageManagementProvider::MessageManage('post-comment-add-successfully');
            return $message;
        }catch(\Exception $e){
            $message=MessageManagementProvider::MessageManage('post-comment-add-error');
            return $message;
        }
    }

}
