<?php

namespace App\Http\Controllers\frontend\become_a_partner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth; 
use App\Models\Subscription; 
use App\Models\OrderMeta;
use App\Models\Transaction;
use Maatwebsite\Excel\Facades\Excel;
use DataTables;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use PDF;
use App\Exports\SubscriptionExportForPartner;

class BillingPartnerController extends Controller
{
    public function index(Request $request){
        $code=Auth::user()->code;
        $sevenDaysAgo = date('Y-m-d', strtotime('-7 days'));
        $currentDate=date('Y-m-d H:i:s');
        if($request->duration=='week'){
            $datas=Subscription::select(
                'subscriptions.id',
                'subscriptions.serial_number',
                'users.partner_code',
                'users.company',
                DB::raw('CONCAT_WS(" ", users.f_name, users.l_name) as name'),
                'subscriptions.plan_name',
                'subscriptions.plan_duration',
                'subscriptions.currency_code',
                'subscriptions.plan_rate',
                'subscriptions.addon_rate',
                'subscriptions.rate',
                'subscriptions.quantity',
                'subscriptions.plan_total_rate',
                'subscriptions.addon_total_rate',
                'subscriptions.total_rate',
                'subscriptions.tax',
                'subscriptions.tax_percentage',
                'subscriptions.tax_name',
                'subscriptions.grand_amount',
                'subscriptions.start_at',
                'subscriptions.end_at',
                'subscriptions.status',
                'subscriptions.remarks',
                'subscriptions.partner_commission_percentage',
                'subscriptions.partner_commission_amount',
                'industries.title as industry_title'
            )->join('users', 'subscriptions.user_id', '=', 'users.id')
            ->join('pricings', 'subscriptions.plan_id', '=', 'pricings.id')
            ->join('industries', 'pricings.lob_id', '=', 'industries.id')
            ->with('OrderMeta')
            ->where('users.partner_code', $code)
            ->whereBetween('subscriptions.start_at', [$sevenDaysAgo, $currentDate])
            ->orderBy('subscriptions.id', 'DESC')
            ->get();
        }else{
            $datas=Subscription::select(
                'subscriptions.id',
                'subscriptions.serial_number',
                'users.company',
                'users.partner_code',
                DB::raw('CONCAT_WS(" ", users.f_name, users.l_name) as name'),
                'subscriptions.plan_name',
                'subscriptions.plan_duration',
                'subscriptions.currency_code',
                'subscriptions.plan_rate',
                'subscriptions.addon_rate',
                'subscriptions.rate',
                'subscriptions.quantity',
                'subscriptions.plan_total_rate',
                'subscriptions.addon_total_rate',
                'subscriptions.total_rate',
                'subscriptions.tax',
                'subscriptions.tax_percentage',
                'subscriptions.tax_name',
                'subscriptions.grand_amount',
                'subscriptions.start_at',
                'subscriptions.end_at',
                'subscriptions.status',
                'subscriptions.remarks',
                'subscriptions.partner_commission_percentage',
                'subscriptions.partner_commission_amount',
                'industries.title as industry_title'
            )->join('users', 'subscriptions.user_id', '=', 'users.id')
            ->join('pricings', 'subscriptions.plan_id', '=', 'pricings.id')
            ->join('industries', 'pricings.lob_id', '=', 'industries.id')
            ->with('OrderMeta')
            ->where('users.partner_code', $code)
            ->orderBy('subscriptions.id', 'DESC')
            ->get();
        }
        return view('frontend.become_a_partner.billing.index', compact('datas'));
    }

    public function show($id){
        try{
            $data=Subscription::find(Crypt::decrypt($id));
            return view('frontend.become_a_partner.billing.view',compact('data'));
        }catch(\Exception $e){
            Log::error('become_a_partner Billing View:'.$e);
            return redirect()->back();
        }
    }

    public function pdf($id){
        try{
            $subscriptionId = Crypt::decrypt($id);
            $data = Subscription::find($subscriptionId);
            if(!$data){  return redirect()->back();}

            $orderMeta=OrderMeta::where('subscription_id',$data->id)->get();
            $title='Invoice';

            if (!$data) {
                abort(404, 'Subscription not found.');
            }

            $datas = [
                'title' => $title,
                'data' => $data,
                'orderMeta'=>$orderMeta
            ];

            $pdf = PDF::loadView('frontend.become_a_partner.billing.pdf', $datas);

            return $pdf->download('invoice.pdf');
            // return $pdf->stream('invoice.pdf');
        }catch(\Exception $e){
            Log::error('Customer Billing Pdf:'.$e);
            return redirect()->back();
        }
    }

    public function excel(){
        return Excel::download(new SubscriptionExportForPartner, 'subscription.xlsx');
    }
}
