<?php

namespace App\Http\Controllers\frontend\become_a_partner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Providers\MessageManagementProvider;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\PartnerNotification;
use Illuminate\Support\Facades\Log;

class PartnerSettingController extends Controller
{
    public function ChangePassword(Request $request)
    {
        return view('frontend.become_a_partner.change_password');
    }

    //ChangePasswordSave
    public function ChangePasswordSave(Request $request)
    {
        $validateData = $request->validate([
            'old_password' => 'min:8 |required',
            'password' => ['required', 'min:8', 'regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{8,}$/'],
            'confirm_password' => 'required_with:password|same:password|min:8'
        ]);
        try {
            #Match The Old Password
            if (!Hash::check($request->old_password, auth()->user()->password)) {
                $message = MessageManagementProvider::MessageManage('old-password-not-match');
                return redirect()->back()->with('message', $message);
            }

            // Update the user's password
            auth()->user()->update([
                'password' => Hash::make($request->password),
            ]);

            $message = MessageManagementProvider::MessageManage('password-save');
            return redirect()->route('partner.change.password')->with('message', $message);
        } catch (\Exception $e) {
            Log::error('Partner Setting Change Password Save:' . $e);
            return redirect()->back();
        }
    }
    
    //notification
    public function Notifications(){
        PartnerNotification::where("status", '0')->where('user_id',Auth::user()->id)->update(["status" => "1"]);
        $notifications= PartnerNotification::where('user_id',Auth::user()->id)->get();
        return view('frontend.become_a_partner.notification', compact('notifications'));
    }
}
