<?php

namespace App\Http\Controllers\frontend\customer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Subscription;
use App\Models\OrderMeta;
use App\Models\Transaction;
use App\Models\EmailNotification;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Crypt;
use PDF;
use App\Exports\SubscriptionExport;
use Maatwebsite\Excel\Facades\Excel;

class CustomerBillingController extends Controller
{
    public function index(){
        try{
            $list=EmailNotification::where('slug','user-subscription-before-expire-notification')->first();
            $subscription_upgrade_days=$list->description;
            $dt=Carbon::now();
            // $datas=Subscription::where('user_id',Auth::user()->id)->where('end_at','>=',$dt->toDateTimeString())->get();
            $datas=Subscription::where('user_id',Auth::user()->id)->get();
            return view('frontend.customer.billing.index',compact('datas','subscription_upgrade_days'));
        }catch(\Exception $e){
            Log::error('Customer Billing:'.$e);
            return redirect()->back();
        }
    }

    public function show($id){
        try{
            $data=Subscription::find(Crypt::decrypt($id));
            return view('frontend.customer.billing.view',compact('data'));
        }catch(\Exception $e){
            Log::error('Customer Billing View:'.$e);
            return redirect()->back();
        }
    }

    public function pdf($id){
        try{
            $subscriptionId = Crypt::decrypt($id);
            $data = Subscription::find($subscriptionId);
            if(!$data){  return redirect()->back();}

            $orderMeta=OrderMeta::where('subscription_id',$data->id)->get();
            $transaction = Transaction::where('subscription_id', $data->id)->where('status', 'Success')->first();
            $title='Invoice';

            if (!$data) {
                abort(404, 'Subscription not found.'); 
            }

            $datas = [
                'title' => $title,
                'data' => $data,
                'orderMeta'=>$orderMeta,
                'transaction' => $transaction
            ];
            // return view('frontend.customer.billing.pdf', $datas);
            //$pdf = PDF::loadView('frontend.customer.billing.pdf', $datas);
            $pdf = PDF::loadView('frontend.customer.billing.pdf', $datas)->setPaper('A4', 'landscape');
            return $pdf->download('invoice.pdf');
            // return $pdf->stream('invoice.pdf');
        }catch(\Exception $e){
            Log::error('Customer Billing Pdf:'.$e);
            return redirect()->back();
        }
    }

    public function excel(){
        return Excel::download(new SubscriptionExport, 'subscription.xlsx');
    }
}
