<?php

namespace App\Http\Controllers\frontend\customer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Subscription;
use App\Models\EmailNotification;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class CustomerSubscriptionController extends Controller
{
    public function index(){
        try{
            $list=EmailNotification::where('slug','user-subscription-before-expire-notification')->first();
            $subscription_upgrade_days=$list->description;
            $datas=Subscription::where('user_id',Auth::user()->id)->orderBy('id','DESC')->get();
            return view('frontend.customer.subscription.index',compact('datas','subscription_upgrade_days'));
        }catch(\Exception $e){
            Log::error('Customer Subscription Controller:'.$e);
            return redirect()->back();
        }
    }

}
