<?php

namespace App\Http\Controllers\frontend\operation;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Providers\HelperServiceProvider;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use App\Models\Pricing;
use App\Models\PlanPricing;
use Illuminate\Support\Facades\Log;

class PlanPurchaseController extends Controller
{
    public function Store(Request $request){
        try{
            if(Auth::user()){
                if(Auth::user()->role=='Customer'){
                    if(!$request->page_id){
                        $request=json_decode(Cookie::get('planPurchaseData'));
                        Cookie::queue(Cookie::make('planPurchaseData', '', time() - 3600, '/', null, true, false));
                    }
                    //store
                    if(@$request->page_id && $request->child_page_id ){
                        $priceGet=Pricing::where('id',$request->page_id)->where('status','Published')->first();
                        $priceChildGet=PlanPricing::where('id',$request->child_page_id)->where('price_id',$request->page_id)->first();
                        if($priceGet && $priceChildGet){
                            $newArray=array();
                            $newArray['page_id']=@$request->page_id;
                            $newArray['child_page_id']=@$request->child_page_id;
                            $newArray['no_of_user']=@$request->no_of_user;
                            $newArray['switchPlanBasic']=(@$request->plan_screen_view=='basic-mobile')?@$request->switchPlan_basic_mobile:@$request->switchPlanBasic;
                            $newArray['switchPlanAdvance']=(@$request->plan_screen_view=='advance-mobile')?@$request->switchPlan_advance_mobile:@$request->switchPlanAdvance;
                            $newArray['switchPlanEcommerce']=(@$request->plan_screen_view=='ecommerce-mobile')?@$request->switchPlan_ecommerce_mobile:@$request->switchPlanEcommerce;
                            $newArray['price_addon']=@$request->price_addon;
                            Session::put('PlanPurchaseData', json_encode($newArray));
                            return redirect()->route('checkout');
                        }
                    }
                    return redirect()->route('home');
                }else{
                    return redirect()->back();
                }
            }else{
                $newArray=array();
                $newArray['page_id']=@$request->page_id;
                $newArray['child_page_id']=@$request->child_page_id;
                $newArray['no_of_user']=@$request->no_of_user;
                $newArray['switchPlanBasic']=(@$request->plan_screen_view=='basic-mobile')?@$request->switchPlan_basic_mobile:@$request->switchPlanBasic;
                $newArray['switchPlanAdvance']=(@$request->plan_screen_view=='advance-mobile')?@$request->switchPlan_advance_mobile:@$request->switchPlanAdvance;
                $newArray['switchPlanEcommerce']=(@$request->plan_screen_view=='ecommerce-mobile')?@$request->switchPlan_ecommerce_mobile:@$request->switchPlanEcommerce;
                $newArray['price_addon']=@$request->price_addon;
                Cookie::queue(Cookie::make('planPurchaseData', json_encode($newArray), 5, '/', null, true, false));
                return redirect()->route('login');
            }
        }catch(\Exception $e){
            Log::error('Plan Purchase Error '.$e);
            return redirect()->back();
        }
    }
}
