<?php

namespace App\Http\Controllers\frontend\operation;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Pricing;
use App\Models\PricingAddons;
use App\Models\PricingFeature;
use App\Models\Currency;
use App\Models\Industries;
use App\Models\PlanPricing;
use App\Models\GST;
use App\Models\User;
use App\Models\OrderMeta;
use App\Models\Transaction;
use App\Models\Notification;
use App\Models\PartnerNotification;
use App\Models\EmailManagement;
use App\Models\SubscriptionAddons;
use App\Models\Subscription;
use App\Models\SubscriptionNextBilling;
use App\Providers\EmailProvider;
use App\Providers\MessageManagementProvider;
use App\Providers\SubscriptionNotificationProvider;
use App\Providers\HelperServiceProvider;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Log;
use stdClass;
use App\Services\PaymentGatewayFactory;
use DB;

class SubscriptionUpgradePaidController extends Controller
{
    public function SubscriptionUpgrade(Request $request){
        try{
            $subscription_id= Crypt::decrypt($request->token);
            if(!$subscription_id){return;}
            $list=Subscription::find($subscription_id);
            // $language=HelperServiceProvider::DefaultLanguage();
            $language='en';
            $country=HelperServiceProvider::DefaultCountry($request);
            $currency=HelperServiceProvider::DefaultCurrency();
            if($list){
                $pricing=Pricing::where('id',$list->plan_id)->where('status','Published')->where('language',$language)->first();
                if($pricing){
                    $check_data=Industries::where('id',$pricing->lob_id)->where('status','Published')->where('language',$language)->first();
                    if($check_data){
                        $plan_list=PlanPricing::where('price_id',$pricing->id)->where('country_code',$country)->limit(4)->get();
                        if($plan_list->isEmpty()){
                            $plan_list=PlanPricing::where('price_id',$pricing->id)->where('country_code','Other')->limit(4)->get();
                            if($plan_list->isEmpty()){
                                $plan_list=PlanPricing::where('price_id',$pricing->id)->where('country_code','IN')->limit(4)->get();
                            }
                        }
                        return view('frontend.customer.subscription.upgrade-popup',compact('plan_list','pricing','subscription_id'));
                    }
                }
            }
            return ;
        }catch(\Exception $e){
            Log::error('Subscription Upgrade Paid Controller:'.$e);
            return ;
        }
    }

    public function SubscriptionUpgradeStore(Request $request){
        try{
            if(@$request->page_id && $request->child_page_id && $request->subscription_id ){
                $priceGet=Pricing::where('id',$request->page_id)->where('status','Published')->first();
                $priceChildGet=PlanPricing::where('id',$request->child_page_id)->where('price_id',$request->page_id)->first();
                if($priceGet && $priceChildGet){
                    $no_of_user=$request->no_of_user;
                    if($priceChildGet->plan_type=='Ecommerce'){
                        $no_of_user=$priceChildGet->no_of_order;
                    }

                    //checkout page detail
                    $checkoutPageDetail=Subscription::find($request->subscription_id);

                    //plan duration
                    if($request->switchPlanEcommerce){
                        $switchPlan=$request->switchPlanEcommerce;
                    }elseif($request->switchPlanAdvance){
                        $switchPlan=$request->switchPlanAdvance;
                    }elseif($request->switchPlanBasic){
                        $switchPlan=$request->switchPlanBasic;
                    }

                    if($switchPlan=='MTH'){
                        $rate=number_format($priceChildGet->monthly, 2, ".", "");
                        $total_amount=number_format($priceChildGet->monthly*$no_of_user, 2, ".", "");
                    }elseif($switchPlan=='QTR'){
                        $rate=number_format($priceChildGet->quaterly, 2, ".", "");
                        $total_amount=number_format($priceChildGet->quaterly*$no_of_user, 2, ".", "");
                    }elseif($switchPlan=='YLY'){
                        $rate=number_format($priceChildGet->yearly, 2, ".", "");
                        $total_amount=number_format($priceChildGet->yearly*$no_of_user, 2, ".", "");
                    }

                    //tax
                    $taxList = GST::where('country_code', $priceChildGet->country_code)->first();
                    if (!$taxList) {
                        $taxList = GST::where('country_code', 'Other')->first();
                    }
                    $tax=number_format(($taxList->rate/100)* $total_amount, 2, ".", "");
                    $grand_amount  =  number_format($total_amount + $tax,2,".","");




                    //store data
                    //serial number generate
                    $currentYear = date('Y');
                    $maxSubscriptionSlNo = Subscription::whereYear('created_at', $currentYear)->max('sl_no');
                    if(!$maxSubscriptionSlNo){$maxSubscriptionSlNo=1;}else{ $maxSubscriptionSlNo=$maxSubscriptionSlNo+1; }
                    $serialNumber='INV/'.$currentYear.'/'.$maxSubscriptionSlNo;

                    // partner commission 
                    $partner_commission_percentage =0;
                    $partner_commission_amount =0;
                    $partnerDetail=User::select('partner_commission_percentage')->where('code', Auth::user()->partner_code)->first();
                    if($partnerDetail){
                        $partner_commission_percentage=$partnerDetail->partner_commission_percentage;
                        $partner_commission_amount=number_format(($partner_commission_percentage/100)*$grand_amount , 2, ".","");
                    }

                    //Subscription table
                    $item=new Subscription();
                    $item->sl_no=$maxSubscriptionSlNo;
                    $item->serial_number=$serialNumber;
                    $item->user_id=Auth::user()->id;
                    $item->plan_id=$request->page_id;
                    $item->plan_name=$priceChildGet->plan_type;
                    $item->plan_duration=$switchPlan;
                    $item->country_code=$priceChildGet->country_code;
                    $item->currency_code=$priceChildGet->currency;
                    $item->plan_rate=$rate;
                    $item->addon_rate=0.00;
                    $item->rate=$rate;
                    $item->quantity=$no_of_user;
                    $item->plan_total_rate=$total_amount;
                    $item->addon_total_rate=0.00;
                    $item->total_rate=$total_amount;
                    $item->tax=$tax;
                    $item->tax_percentage=$taxList->rate;
                    $item->tax_name=$taxList->tax_name;
                    $item->grand_amount=$grand_amount;
                    $item->partner_commission_percentage=$partner_commission_percentage;
                    $item->partner_commission_amount=$partner_commission_amount;
                    $item->payment_mode=$request->payment_mode;
                    $item->status='Pending';
                    $item->save();

                    $subscription_id=$item->id;

                    //order meta table
                    $orderMetaList=OrderMeta::where('subscription_id',$request->subscription_id)->get();
                    $oldOrderMetaArray=array();
                    foreach($orderMetaList as  $orderMeta){
                        $oldOrderMetaArray[$orderMeta->key]=$orderMeta->value;
                    }

                    $order_meta=[
                        ['subscription_id'=>$subscription_id,'key'=>'company_name', 'value'=>$oldOrderMetaArray['company_name']],
                        ['subscription_id'=>$subscription_id,'key'=>'company_code', 'value'=>$oldOrderMetaArray['company_code']],
                        ['subscription_id'=>$subscription_id,'key'=>'country', 'value'=>$oldOrderMetaArray['country']],
                        ['subscription_id'=>$subscription_id,'key'=>'state', 'value'=>$oldOrderMetaArray['state']],
                        ['subscription_id'=>$subscription_id,'key'=>'city', 'value'=>$oldOrderMetaArray['city']],
                        ['subscription_id'=>$subscription_id,'key'=>'address_1', 'value'=>$oldOrderMetaArray['address_1']],
                        ['subscription_id'=>$subscription_id,'key'=>'address_2', 'value'=>$oldOrderMetaArray['address_2']],
                        ['subscription_id'=>$subscription_id,'key'=>'pincode', 'value'=>$oldOrderMetaArray['pincode']],
                        ['subscription_id'=>$subscription_id,'key'=>'industry', 'value'=>$oldOrderMetaArray['industry']],
                        ['subscription_id'=>$subscription_id,'key'=>'no_of_employee', 'value'=>$oldOrderMetaArray['no_of_employee']],
                        ['subscription_id'=>$subscription_id,'key'=>'first_name', 'value'=>$oldOrderMetaArray['first_name']],
                        ['subscription_id'=>$subscription_id,'key'=>'last_name', 'value'=>$oldOrderMetaArray['last_name']],
                        ['subscription_id'=>$subscription_id,'key'=>'designation', 'value'=>$oldOrderMetaArray['designation']],
                        ['subscription_id'=>$subscription_id,'key'=>'address', 'value'=>$oldOrderMetaArray['address']],
                        ['subscription_id'=>$subscription_id,'key'=>'email', 'value'=>$oldOrderMetaArray['email']],
                        ['subscription_id'=>$subscription_id,'key'=>'calling_code', 'value'=>$oldOrderMetaArray['calling_code']],
                        ['subscription_id'=>$subscription_id,'key'=>'phone', 'value'=>$oldOrderMetaArray['phone']],
                        ['subscription_id'=>$subscription_id,'key'=>'billing_company_name', 'value'=>$oldOrderMetaArray['billing_company_name']],
                        ['subscription_id'=>$subscription_id,'key'=>'billing_country', 'value'=>$oldOrderMetaArray['billing_country']],
                        ['subscription_id'=>$subscription_id,'key'=>'billing_state', 'value'=>$oldOrderMetaArray['billing_state']],
                        ['subscription_id'=>$subscription_id,'key'=>'billing_city', 'value'=>$oldOrderMetaArray['billing_city']],
                        ['subscription_id'=>$subscription_id,'key'=>'billing_address_1', 'value'=>$oldOrderMetaArray['billing_address_1']],
                        ['subscription_id'=>$subscription_id,'key'=>'billing_address_2', 'value'=>$oldOrderMetaArray['billing_address_2']],
                        ['subscription_id'=>$subscription_id,'key'=>'billing_email', 'value'=>$oldOrderMetaArray['billing_email']],
                        ['subscription_id'=>$subscription_id,'key'=>'billing_calling_code', 'value'=>$oldOrderMetaArray['billing_calling_code']],
                        ['subscription_id'=>$subscription_id,'key'=>'billing_phone', 'value'=>$oldOrderMetaArray['billing_phone']],
                    ];
                    //document
                    if(@$oldOrderMetaArray['gst_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'gst_number', 'value' => $oldOrderMetaArray['gst_number']];}
                    if(@$oldOrderMetaArray['pan_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'pan_number', 'value' => $oldOrderMetaArray['pan_number']];}
                    if(@$oldOrderMetaArray['trn_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'trn_number', 'value' => $oldOrderMetaArray['trn_number']];}
                    if(@$oldOrderMetaArray['acra_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'acra_number', 'value' => $oldOrderMetaArray['acra_number']];}
                    if(@$oldOrderMetaArray['npwp_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'npwp_number', 'value' => $oldOrderMetaArray['npwp_number']];}
                    if(@$oldOrderMetaArray['tax_registration_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'tax_registration_number', 'value' => $oldOrderMetaArray['tax_registration_number']];}
                    if(@$oldOrderMetaArray['company_registration_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'company_registration_number', 'value' => $oldOrderMetaArray['company_registration_number']];}

                    OrderMeta::insert($order_meta);

                    //old subscription update
                    $oldSubscription=Subscription::find($request->subscription_id);
                    $oldSubscription->upgrade_status ='1';
                    $oldSubscription->save();

                    //Offline payment
                    if($request->payment_mode=='Offline'){
                        SubscriptionNotificationProvider::Notification($subscription_id);
                        $message=MessageManagementProvider::MessageManage('subscription-upgrade-success');
                        return redirect()->back()->with('message', $message);
                    }else{
                        return SubscriptionNotificationProvider::PaymentAuropay($subscription_id);
                    }
                }
            }
            $message=MessageManagementProvider::MessageManage('subscription-upgrade-error');
            return redirect()->back()->with('message', $message);
        }catch(\Exception $e){
            Log::error('Subscription Upgrade paid Controller store:'.$e);
            $message=MessageManagementProvider::MessageManage('subscription-upgrade-error');
            return redirect()->back()->with('message', $message);
        }
    }

    public function SubscriptionPaid(Request $request){
        $subscription_id= Crypt::decrypt($request->token);
        $subscription=Subscription::find($subscription_id);
        $subscriptionNextBilling = SubscriptionNextBilling::where('subscription_id', $subscription_id)->first();
        //----------------------------------------------
        $subscription_name = $subscription['Pricing']['LOB']['title']."(". $subscription->plan_name .")";
        if($subscription->plan_duration=='MTH'){
            $plan_duration='Monthly';
        }elseif($subscription->plan_duration=='QTR'){
            $plan_duration='Quarterly';
        }elseif($subscription->plan_duration=='YLY'){
            $plan_duration='Yearly';
        }
        $currency_code = $subscription->currency_code;
        $country_code = $subscription->country_code;
        $quantity = ($subscriptionNextBilling && $subscriptionNextBilling->quantity)?$subscriptionNextBilling->quantity:$subscription->quantity;
        $plan_rate = ($subscriptionNextBilling && $subscriptionNextBilling->plan_rate)?$subscriptionNextBilling->plan_rate:$subscription->plan_rate;
        $addon_rate = $subscription->addon_rate;
        $rate = $plan_rate + $addon_rate;
        
        $total_rate = number_format($rate*$quantity, 2, ".", "");

        //tax
        $taxList = GST::where('country_code', $subscription->country_code)->first();
        if (!$taxList) {
            $taxList = GST::where('country_code', 'Other')->first();
        }
        $tax_name=$taxList->tax_name;
        $tax=number_format(($taxList->rate/100)* $total_rate, 2, ".", "");
        $grand_amount = $total_rate + $tax;

        //----------------------------------------------
        return view('frontend.customer.subscription.pay-popup', compact('grand_amount', 'tax_name', 'tax', 'total_rate', 'quantity', 'subscription_id', 'plan_duration', 'subscription_name', 'currency_code', 'country_code'));
    }

    public function SubscriptionPaidSave(Request $request,$id){
        try{
            $subscription_id= Crypt::decrypt($id);
            if(!$subscription_id){return;}
            $list=Subscription::find($subscription_id);
            $subscriptionNextBilling = SubscriptionNextBilling::where('subscription_id', $subscription_id)->first();
            if($list){
                $priceGet=Pricing::where('id',$list->plan_id)->where('status','Published')->first();
                if($priceGet){
                    $check_data=Industries::where('id',$priceGet->lob_id)->where('status','Published')->first();
                    if($check_data){
                        //store data
                        //serial number generate
                        $currentYear = date('Y');
                        $maxSubscriptionSlNo = Subscription::whereYear('created_at', $currentYear)->max('sl_no');
                        if(!$maxSubscriptionSlNo){$maxSubscriptionSlNo=1;}else{ $maxSubscriptionSlNo=$maxSubscriptionSlNo+1; }
                        $serialNumber='INV/'.$currentYear.'/'.$maxSubscriptionSlNo;

                        //----------------------------------------------------------------------
                        $quantity = ($subscriptionNextBilling && $subscriptionNextBilling->quantity)?$subscriptionNextBilling->quantity:$list->quantity;
                        $plan_rate = ($subscriptionNextBilling && $subscriptionNextBilling->plan_rate)?$subscriptionNextBilling->plan_rate:$list->plan_rate;
        
                        $addon_rate = $list->addon_rate;
                        $rate = $addon_rate + $plan_rate;
                        $plan_total_rate = number_format($plan_rate * $quantity, 2, ".", '');
                        $addon_total_rate = number_format($addon_rate * $quantity, 2, ".", '');
                        $total_rate = number_format($plan_total_rate + $addon_total_rate, 2, ".", '');

                        //tax
                        $taxList = GST::where('country_code', $list->country_code)->first();
                        if (!$taxList) {
                            $taxList = GST::where('country_code', 'Other')->first();
                        }
                        $tax_name=$taxList->tax_name;
                        $tax=number_format(($taxList->rate/100)* $total_rate, 2, ".", "");
                        $grand_amount = $total_rate + $tax;
                        $tax_percentage = $taxList->rate;
                        
                        //----------------------------------------------------------------------
                        // partner commission 
                        $partner_commission_percentage =0;
                        $partner_commission_amount =0;
                        $partnerDetail=User::select('partner_commission_percentage')->where('code', Auth::user()->partner_code)->first();
                        if($partnerDetail){
                            $partner_commission_percentage=$partnerDetail->partner_commission_percentage;
                            $partner_commission_amount=number_format(($partner_commission_percentage/100)*$grand_amount , 2, ".","");
                        }

                        //subscription table
                        $item=new Subscription();
                        $item->sl_no=$maxSubscriptionSlNo;
                        $item->serial_number=$serialNumber;
                        $item->user_id=Auth::user()->id;
                        $item->plan_id=$list->plan_id;
                        $item->plan_name=$list->plan_name;
                        $item->plan_duration=$list->plan_duration;
                        $item->country_code=$list->country_code;
                        $item->currency_code=$list->currency_code;
                        $item->plan_rate=$plan_rate;
                        $item->addon_rate=$addon_rate;
                        $item->rate=$rate;
                        $item->quantity=$quantity;
                        $item->plan_total_rate=$plan_total_rate;
                        $item->addon_total_rate=$addon_total_rate;
                        $item->total_rate=$total_rate;
                        $item->tax=$tax;
                        $item->tax_percentage=$tax_percentage;
                        $item->tax_name=$tax_name;
                        $item->grand_amount=$grand_amount;
                        $item->partner_commission_percentage=$partner_commission_percentage;
                        $item->partner_commission_amount=$partner_commission_amount;
                        $item->payment_mode=$request->payment_mode;
                        $item->status='Pending';
                        $item->save();

                        $subscription_id=$item->id;

                        //subscription addon 
                        $subscriptionAddonsName=[]; 
                        $addonList=SubscriptionAddons::where('subscription_id',$subscription_id)->get();
                        if(!$addonList->isEmpty()){
                            foreach($addonList as $addonItem){
                                $addonData=new SubscriptionAddons();
                                $addonData->subscription_id=$subscription_id;
                                $addonData->name=$addonItem->name;
                                $addonData->rate=$addonItem->rate;
                                $addonData->save();
                                $subscriptionAddonsName[]=$addonItem->name;
                            }
                        }

                        //order meta table
                        $orderMetaList=OrderMeta::where('subscription_id',$list->id)->get();
                        $oldOrderMetaArray=array();
                        foreach($orderMetaList as  $orderMeta){
                            $oldOrderMetaArray[$orderMeta->key]=$orderMeta->value;
                        }

                        $order_meta=[
                            ['subscription_id'=>$subscription_id,'key'=>'company_name', 'value'=>$oldOrderMetaArray['company_name']],
                            ['subscription_id'=>$subscription_id,'key'=>'company_code', 'value'=>$oldOrderMetaArray['company_code']],
                            ['subscription_id'=>$subscription_id,'key'=>'country', 'value'=>$oldOrderMetaArray['country']],
                            ['subscription_id'=>$subscription_id,'key'=>'state', 'value'=>$oldOrderMetaArray['state']],
                            ['subscription_id'=>$subscription_id,'key'=>'city', 'value'=>$oldOrderMetaArray['city']],
                            ['subscription_id'=>$subscription_id,'key'=>'address_1', 'value'=>$oldOrderMetaArray['address_1']],
                            ['subscription_id'=>$subscription_id,'key'=>'address_2', 'value'=>$oldOrderMetaArray['address_2']],
                            ['subscription_id'=>$subscription_id,'key'=>'pincode', 'value'=>$oldOrderMetaArray['pincode']],
                            ['subscription_id'=>$subscription_id,'key'=>'industry', 'value'=>$oldOrderMetaArray['industry']],
                            ['subscription_id'=>$subscription_id,'key'=>'no_of_employee', 'value'=>$oldOrderMetaArray['no_of_employee']],
                            ['subscription_id'=>$subscription_id,'key'=>'first_name', 'value'=>$oldOrderMetaArray['first_name']],
                            ['subscription_id'=>$subscription_id,'key'=>'last_name', 'value'=>$oldOrderMetaArray['last_name']],
                            ['subscription_id'=>$subscription_id,'key'=>'designation', 'value'=>$oldOrderMetaArray['designation']],
                            ['subscription_id'=>$subscription_id,'key'=>'address', 'value'=>$oldOrderMetaArray['address']],
                            ['subscription_id'=>$subscription_id,'key'=>'email', 'value'=>$oldOrderMetaArray['email']],
                            ['subscription_id'=>$subscription_id,'key'=>'calling_code', 'value'=>$oldOrderMetaArray['calling_code']],
                            ['subscription_id'=>$subscription_id,'key'=>'phone', 'value'=>$oldOrderMetaArray['phone']],
                            ['subscription_id'=>$subscription_id,'key'=>'billing_company_name', 'value'=>$oldOrderMetaArray['billing_company_name']],
                            ['subscription_id'=>$subscription_id,'key'=>'billing_country', 'value'=>$oldOrderMetaArray['billing_country']],
                            ['subscription_id'=>$subscription_id,'key'=>'billing_state', 'value'=>$oldOrderMetaArray['billing_state']],
                            ['subscription_id'=>$subscription_id,'key'=>'billing_city', 'value'=>$oldOrderMetaArray['billing_city']],
                            ['subscription_id'=>$subscription_id,'key'=>'billing_address_1', 'value'=>$oldOrderMetaArray['billing_address_1']],
                            ['subscription_id'=>$subscription_id,'key'=>'billing_address_2', 'value'=>$oldOrderMetaArray['billing_address_2']],
                            ['subscription_id'=>$subscription_id,'key'=>'billing_email', 'value'=>$oldOrderMetaArray['billing_email']],
                            ['subscription_id'=>$subscription_id,'key'=>'billing_calling_code', 'value'=>$oldOrderMetaArray['billing_calling_code']],
                            ['subscription_id'=>$subscription_id,'key'=>'billing_phone', 'value'=>$oldOrderMetaArray['billing_phone']],
                        ];
                        //document
                        if(@$oldOrderMetaArray['gst_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'gst_number', 'value' => $oldOrderMetaArray['gst_number']];}
                        if(@$oldOrderMetaArray['pan_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'pan_number', 'value' => $oldOrderMetaArray['pan_number']];}
                        if(@$oldOrderMetaArray['trn_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'trn_number', 'value' => $oldOrderMetaArray['trn_number']];}
                        if(@$oldOrderMetaArray['acra_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'acra_number', 'value' => $oldOrderMetaArray['acra_number']];}
                        if(@$oldOrderMetaArray['npwp_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'npwp_number', 'value' => $oldOrderMetaArray['npwp_number']];}
                        if(@$oldOrderMetaArray['tax_registration_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'tax_registration_number', 'value' => $oldOrderMetaArray['tax_registration_number']];}
                        if(@$oldOrderMetaArray['company_registration_number']){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'company_registration_number', 'value' => $oldOrderMetaArray['company_registration_number']];}

                        OrderMeta::insert($order_meta);

                        //old subscription update
                        $oldSubscription=Subscription::find($list->id);
                        $oldSubscription->upgrade_status ='1';
                        $oldSubscription->save();

                        //Offline payment
                        if($request->payment_mode=='Offline'){
                            SubscriptionNotificationProvider::Notification($subscription_id);

                            $message=MessageManagementProvider::MessageManage('subscription-paid-success');
                            return redirect()->back()->with('message', $message);
                        }else{    //auropay
                            return SubscriptionNotificationProvider::PaymentAuropay($subscription_id);
                        }
                    }
                }
            }
            $message=MessageManagementProvider::MessageManage('subscription-paid-error');
            return redirect()->back()->with('message', $message);
        }catch(\Exception $e){
            Log::error('Subscription Upgrade paid Controller store:'.$e);
            $message=MessageManagementProvider::MessageManage('subscription-paid-error');
            return redirect()->back()->with('message', $message);
        }
    }

    public function SubscriptionPaymentAuropay($id){
        try{
            $subscription_id= Crypt::decrypt($id);
            if(!$subscription_id){return;}
            return SubscriptionNotificationProvider::PaymentAuropay($subscription_id);
        }catch(\Exception $e){
            Log::error('Subscription Upgrade paid Controller store:'.$e);
            $message=MessageManagementProvider::MessageManage('subscription-paid-error');
            return redirect()->back()->with('message', $message);
        }
    }
}
