<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Fortify\TwoFactorAuthenticatable;
use Laravel\Jetstream\HasProfilePhoto;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens;
    use HasFactory;
    use HasProfilePhoto;
    use Notifiable;
    use TwoFactorAuthenticatable;

    public function CreatedBy(){
        return $this->belongsTo(User::class,'created_by','id');
    }
    public function UpdatedBy(){
        return $this->belongsTo(User::class,'updated_by','id');
    }
    public function DeletedBy(){
        return $this->belongsTo(User::class,'deleted_by','id');
    }
    public function State(){
        return $this->belongsTo(StateList::class,'state','code');
    }
    public function Country(){
        return $this->belongsTo(CountryList::class,'country','code');
    }
    public function CallingCode(){
        return $this->belongsTo(CallingCode::class,'calling_code','country_code');
    }


    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'f_name',
        'code',
        'partner_code',
        'l_name',
        'company',
        'country',
        'state',
        'city',
        'address',
        'pincode',
        'email',
        'calling_code',
        'phone',
        'role',
        'password',
        'is_email_verified',
        'created_by',
        'updated_by',
        'deleted_by',
        'remember_token',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
        'two_factor_recovery_codes',
        'two_factor_secret',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * The accessors to append to the model's array form.
     *
     * @var array
     */
    protected $appends = [
        'profile_photo_url',
    ];
}
