<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use App\Models\Subscription;
use App\Models\OrderMeta;
use App\Models\EmailManagement;
use App\Models\User;
use App\Models\SubscriptionAddons;
use App\Models\Transaction;
use App\Models\Notification;
use App\Models\CustomerNotification;
use App\Models\PartnerNotification;
use Mail;
use stdClass;
use DB;
use App\Providers\EmailProvider;
use App\Services\PaymentGatewayFactory;

class SubscriptionNotificationProvider extends ServiceProvider
{
    //subscription_id -> subscription table id
    //admin_status_change -> admin change status of subscription
    public static function Notification($subscription_id, $admin_status_change=false){
        $subscription=Subscription::find($subscription_id);
        if($subscription){
            $user=User::find($subscription->user_id);
            //order meta table
            $orderMetaList=OrderMeta::where('subscription_id',$subscription_id)->get();
            $oldOrderMetaArray=array();
            foreach($orderMetaList as  $orderMeta){
                $oldOrderMetaArray[$orderMeta->key]=$orderMeta->value;
            }
            //subscription check
            $existSubscription=OrderMeta::where('key','email')->where('value',$oldOrderMetaArray['email'])->count();
            


            //subscription mail
            //subscription table 
            $value=new stdClass();
            $value->f_name=$user->f_name;
            $value->l_name=$user->l_name;
            $value->amount= number_format($subscription->grand_amount,2,".","");
            $value->futureDate=$subscription->end_at;
            $value->currentDate=$subscription->start_at;
            $value->currency_code=$subscription->currency_code;
            $value->subscription_name=$subscription['Pricing']['LOB']['title'];
            $value->plan_name=$subscription->plan_name;
            $value->plan_duration=$subscription->plan_duration;
            $value->number_of_user=$subscription->quantity;
            $value->email=$subscription['User']['email'];
            $value->phone=$subscription['User']['phone'];
            $value->SubscriptionStatus=$subscription->status;

            //subscription child table
            $value->company=@$oldOrderMetaArray['company_name'];
            $value->addressLine1=@$oldOrderMetaArray['address_1'];
            $value->addressLine2=@$oldOrderMetaArray['address_2'];
            $value->city=@$oldOrderMetaArray['city'];
            $value->state=@$oldOrderMetaArray['state'];
            $value->country=@$oldOrderMetaArray['country'];
            $value->pincode=@$oldOrderMetaArray['pincode'];
            $value->industry=@$oldOrderMetaArray['industry'];
            $value->designation=@$oldOrderMetaArray['designation'];
            $value->contactPersonFirstName=@$oldOrderMetaArray['first_name'];
            $value->contactPersonLastName=@$oldOrderMetaArray['last_name'];
            $value->contactPersonEmail=@$oldOrderMetaArray['email'];
            $value->contactPersonPhoneNo=@$oldOrderMetaArray['phone'];
            $value->CustomerOf='Aurobees';
            $value->CompanyCode=@$oldOrderMetaArray['company_code'];
            if($subscription->plan_name=='Free-Trial'){ 
                $value->planType='Free';
            }elseif($subscription->plan_name=='Basic'){ 
                $value->planType='Paid-Basic';
            }elseif($subscription->plan_name=='Advance'){ 
                $value->planType='Paid-Advanced';
            }elseif($subscription->plan_name=='Ecommerce'){ 
                $value->planType='Paid-E-commerce';
            }
            $value->isWoocommerceRequired=$subscription->plan_name=='Ecommerce'?'Yes':'No';

            //subscription addone
            $subscriptionAddonsList = SubscriptionAddons::select(DB::raw('GROUP_CONCAT(name) as names'))->where('subscription_id', $subscription->id)->first();
            if($subscriptionAddonsList){
                $subscriptionAddonsName=$subscriptionAddonsList->names;
            }else{
                $subscriptionAddonsName='';
            }
            $value->subscriptionAddonsName=$subscriptionAddonsName;

            //only status change admin
            if($admin_status_change){
                EmailProvider::Email('admin_status_change_subscription', $user->email, $value );
            }else{
                //status success
                if($subscription->status=='Active'){
                    //transaction table
                    $transaction=Transaction::where('subscription_id', $subscription_id)->where('status', 'Success')->first();
                    if($transaction){
                        $value->transaction_status='Success';
                        $value->transaction_id=@$transaction->transaction_id;
                        $value->transaction_payment_mode=$subscription->payment_mode;
                    }
                    //email
                    $finance_team_email_list=EmailManagement::where('key','finance_team_email')->first();
                    $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
                    if($subscription->plan_name=='Free-Trial'){
                        //Free Trial subscription
                        EmailProvider::Email('customer_subscribe_plan_free_trial', $user->email, $value );
                        EmailProvider::Email('finance_team_subscribe_plan_free', $finance_team_email_list->title, $value );
                        EmailProvider::Email('support_team_subscribe_plan_free', $support_team_email_list->title, $value );
                    }elseif($existSubscription==1){
                        //new subscription
                        if($subscription->payment_mode =='auropay'){
                            EmailProvider::Email('customer_subscribe_plan_paid_auropay', $user->email, $value );
                        }else{
                            EmailProvider::Email('customer_subscribe_plan_paid', $user->email, $value );
                        }
                        EmailProvider::Email('finance_team_subscribe_plan_paid', $finance_team_email_list->title, $value );
                        EmailProvider::Email('support_team_subscribe_plan_paid', $support_team_email_list->title, $value );
                    }else{
                        //upgrade subscription
                        if($subscription->payment_mode =='auropay'){
                            EmailProvider::Email('customer_subscribe_plan_upgrade_auropay', $user->email, $value );
                        }else{
                            EmailProvider::Email('customer_subscribe_plan_upgrade', $user->email, $value );
                        }
                        EmailProvider::Email('finance_team_subscribe_plan_upgrade', $finance_team_email_list->title, $value );
                        EmailProvider::Email('support_team_subscribe_plan_upgrade', $support_team_email_list->title, $value );
                    }
                    //admin notification
                    $notification=new Notification();
                    $notification->notification_from= '3';
                    $notification->table_id= $subscription->id;
                    $notification->title=@$subscription['User']['f_name'].' '.@$subscription['User']['l_name'].' Purchase Lob Subscription';
                    $notification->description=@$subscription['User']['f_name'].' '.@$subscription['User']['l_name'].' Purchase '.@$subscription['Pricing']['LOB']['title']. ' ('.$subscription->plan_name.').';
                    $notification->save();
                    //partner notification
                    if(@$subscription['User']['partner_code']){
                        $partnerDetail=User::where('code',$subscription['User']['partner_code'])->first();
                        if($partnerDetail){
                            //notification partner
                            $partner_notification=new PartnerNotification();
                            $partner_notification->user_id =$partnerDetail->id;
                            $partner_notification->notification_from ='3';
                            $partner_notification->table_id =$subscription->id;
                            $partner_notification->notification= @$subscription['User']['f_name'].' '.@$subscription['User']['l_name'].' Purchase '.@$subscription['Pricing']['LOB']['title']. ' ('.$subscription->plan_name.').';
                            $partner_notification->save();
                        }
                    } 
                    //customer notification
                    $item= new CustomerNotification();
                    $item->subscription_id = $subscription->id;
                    $item->user_id=$subscription->user_id;
                    $item->notification=@$subscription['Pricing']['LOB']['title']. ' ('.$subscription->plan_name.'). now activated.';
                    $item->save();
                
                }else{
                    EmailProvider::Email('customer_subscribe_plan_pending_payment', $user->email, $value );

                    //admin notification
                    $notification=new Notification();
                    $notification->notification_from= '3';
                    $notification->table_id= $subscription->id;
                    $notification->title=@$subscription['User']['f_name'].' '.@$subscription['User']['l_name'].' Purchase Lob Subscription';
                    $notification->description=@$subscription['User']['f_name'].' '.@$subscription['User']['l_name'].' Purchase '.@$subscription['Pricing']['LOB']['title']. ' ('.$subscription->plan_name.') and payment is pending.';
                    $notification->save();
                    //partner notification
                    if(@$subscription['User']['partner_code']){
                        $partnerDetail=User::where('code',$subscription['User']['partner_code'])->first();
                        if($partnerDetail){
                            //notification partner
                            $partner_notification=new PartnerNotification();
                            $partner_notification->user_id =$partnerDetail->id;
                            $partner_notification->notification_from ='3';
                            $partner_notification->table_id =$subscription->id;
                            $partner_notification->notification= @$subscription['User']['f_name'].' '.@$subscription['User']['l_name'].' Purchase '.@$subscription['Pricing']['LOB']['title']. ' ('.$subscription->plan_name.')  and payment is pending.';
                            $partner_notification->save();
                        }
                    } 
                    //customer notification
                    $item= new CustomerNotification();
                    $item->subscription_id = $subscription->id;
                    $item->user_id=$subscription->user_id;
                    $item->notification='Your subscription purchase is successful, but the payment is still pending. Please complete the payment to activate your subscription.';
                    $item->save();
                
                }
            }
        }
    }

    public static function PaymentAuropay($subscription_id){
        try{
            $list=Subscription::find($subscription_id);
            if($list){
                //transaction
                $transaction                    =   new Transaction();
                $transaction->subscription_id   =   $subscription_id;
                $transaction->transaction_id    =   '';
                $transaction->status            =   'Pending';
                $transaction->message           =   $list->payment_mode;
                $transaction->amount            =   $list->grand_amount;
                $transaction->currency          =   $list->currency_code;
                $transaction->save();

                $ReferenceNo = 'AURO_'.date('Ymd').'_'.$transaction->id.'_'.$subscription_id;

                $gateway    = PaymentGatewayFactory::create($list->payment_mode);
                $res        = $gateway->charge($list->grand_amount, $ReferenceNo);
                Log::info('Auropay response: ' . json_encode($res));
                if(isset($res['paymentLink']) && isset($res['id']) && isset($res['title'])){
                    return redirect($res['paymentLink']);
                    exit;
                }else{
                    Log::error('Unable to create the payment link - ' . json_encode($res));
                    $message = MessageManagementProvider::MessageManage('unable-to-create-the-payment-link');
                    $msg=isset($res['message'])?$res['message']:'';
                    $message = str_replace('{Message}',$msg, $message);
                   return redirect()->route('home')->with('message', $message);
                }
            }
        }catch(\Exception $e){
            Log::error('Subscription Upgrade paid Controller store:'.$e);
            $message=MessageManagementProvider::MessageManage('subscription-paid-error');
            return redirect()->back()->with('message', $message);
        }
    }
}
