<?php

namespace App\Services;

use App\Contracts\PaymentGateway;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use App\Models\PaymentGatewayKey;
use App\Models\Subscription;
use App\Providers\HelperServiceProvider;
use GuzzleHttp\Psr7\Request;
use Illuminate\Support\Facades\Log;

class AuroPayGateway implements PaymentGateway
{
    private $apikey     = 'bGF5bWVudCBnYXRld2F5MDA5=dfsdfsdfdsfsdf432423423434+sfjejd9ghjk';
    private $accesskey  = '0B609BC7D162E22C22A5E8CB10BDB9A1';
    private $secretkey  = 'v44Hrnxt+RDy9lJHous26t9V4chybOAHO/zT5JxQ2Do=';

    public function charge($amount, $ReferenceNo){
        try{
            $refArr         = explode('_', $ReferenceNo);
            $subscriptionID  = $refArr[3];
            $countryCode=Subscription::find($subscriptionID);
            if($countryCode){
                $data=PaymentGatewayKey::where('country_code',$countryCode->country_code)->where('payment_method','auropay')->first();
                
                if($data){
                    if($data->apikey){$this->apikey = $data->apikey;}
                    if($data->accesskey){$this->accesskey = $data->accesskey;}
                    if($data->secretkey){$this->secretkey = $data->secretkey;}
                }
            }

            $currentDate = date('d-m-Y H:i:s');
            $expireOn   = date('d-m-Y H:i:s', strtotime($currentDate . ' +2 days'));
            $requestData = array(
                "expireOn"=> $expireOn,
                "amount"=>  number_format($amount, 2, ".", ""),
                "Customers" => array(array(
                    "firstName"=> Auth::user()->f_name,
                    "lastName"=> Auth::user()->l_name,
                    "phone"=> Auth::user()->phone,
                    "email"=> Auth::user()->email
                )),
                "invoiceNumber"=> "",
                "enableMultiplePayment"=> false,
                "CallbackParameters"=> [
                    "CallbackApiUrl"=> route('callbackauropay'),
                    "ReferenceNo"=> $ReferenceNo
                    ],
                "shortDescription"=> "",
                "title"     => $ReferenceNo,
                "Settings"  => ["displaySummary"=> false],
                "ResponseType"  => 1,
                "paymentDescription"    => ""
            );

            $url        = 'https://api.uat.auropay.net/api/paymentlinks';
            $headers = [
                'x-access-key' => $this->accesskey,
                'x-secret-key' => $this->secretkey,
                'apikey' => $this->apikey, // Add the Bearer token to the headers
            ];

            //return json_encode($requestData);
            Log::info('AuroPay Gateway Construct Info request Data:'. json_encode($requestData));
            // Send the second POST request with JSON data
            $response = Http::withHeaders($headers)->withBody(json_encode($requestData), 'application/json')->post($url);
           Log::info('AuroPay Gateway Construct Info response:'. json_encode($response));
            if ($response->successful()) {
                return $response->json();
            } else {
                return $response;
            }
        }catch(\Exception $e){
            Log::error('AuroPay Gateway Construct Error:'.$e);
        }
    }


}
