<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pricings', function (Blueprint $table) {
            $table->id();
            $table->integer('lob_id')->comment('Lob Table(industries) id');
            $table->string('image')->nullable();
            $table->longText('content')->nullable();
            $table->string('free_trial_text')->nullable();
            $table->longText('free_trial_content')->nullable();
            $table->string('basic_text')->nullable();
            $table->string('basic_recommended')->nullable();
            $table->longText('basic_content')->nullable();
            $table->string('advance_text')->nullable();
            $table->string('advance_recommended')->nullable();
            $table->longText('advance_content')->nullable();
            $table->string('ecom_text')->nullable();
            $table->string('ecom_recommended')->nullable();
            $table->longText('ecom_content')->nullable();
            $table->string('ecom_minimum_order_text')->nullable();
            $table->string('language')->default('en');
            $table->string('meta_title')->nullable();
            $table->longText('meta_description')->nullable();
            $table->longText('meta_keywords')->nullable();
            $table->enum('status',['Published','Draft','Trash'])->default('Published');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pricings');
    }
};
