<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('home_customers_derives', function (Blueprint $table) {
            $table->id();
            $table->string('image')->nullable();
            $table->longText('description')->nullable();
            $table->string('language')->default('en');
            $table->enum('status',['Published','Draft','Trash'])->default('Published');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('home_customers_derives');
    }
};
