<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contact_us', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->index();
            $table->string('banner_image')->nullable();
            $table->longText('map')->nullable();
            $table->string('lets_connect_text')->nullable();
            $table->string('first_name_text')->nullable();
            $table->string('last_name_text')->nullable();
            $table->string('email_text')->nullable();
            $table->string('phone_text')->nullable();
            $table->string('corporate_headquarters_text')->nullable();
            $table->string('link_text')->nullable();
            $table->string('link_link')->nullable();
            $table->longText('address')->nullable();
            $table->string('global_offices_text')->nullable();

            $table->string('language')->default('en');
            $table->string('meta_key')->nullable();
            $table->string('meta_title')->nullable();
            $table->longText('meta_description')->nullable();
            $table->enum('status',['Published','Draft','Trash'])->default('Published');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contact_us');
    }
};
