<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('partner_page_contracts', function (Blueprint $table) {
            $table->id();
            $table->integer('partner_page_contents_id')->unique();
            $table->string('title')->nullable();
            $table->string('sub_title')->nullable();
            $table->string('banner_image')->nullable();  
            $table->string('contract_page_image')->nullable();
            $table->string('partner_contract_text')->nullable();
            $table->longText('partner_contract_description')->nullable();
            $table->string('benefits_of_partnership_text')->nullable();
            $table->longText('benefits_of_partnership_description')->nullable();
            $table->string('typical_benefits_text')->nullable();
            $table->string('business_text')->nullable();
            $table->longText('business_description_1')->nullable();
            $table->longText('business_description_2')->nullable();
            $table->string('technical_text')->nullable();
            $table->longText('technical_description_1')->nullable();
            $table->longText('technical_description_2')->nullable();
            $table->string('marketing_text')->nullable();
            $table->longText('marketing_description_1')->nullable();
            $table->longText('marketing_description_2')->nullable();
            $table->string('draft_agreement_text')->nullable();
            $table->string('draft_agreement')->nullable();
            $table->longText('draft_agreement_checkbox_text')->nullable();
            $table->string('contract_verification_image')->nullable();
            $table->longText('contract_verification_description')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('partner_page_contracts');
    }
};
