<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('menu_language_management', function (Blueprint $table) {
            $table->id();
            $table->string('table')->index()->comment('menu table name');
            $table->integer('table_id')->index()->comment('menu table id');
            $table->string('title')->nullable();
            $table->string('description')->nullable();
            $table->string('language')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('menu_language_management');
    }
};
