@php
$header_title="Aurobees | Page Management | Email Management";
$header_name = 'setting_management';
$page_name = 'email_management';
@endphp
@extends('admin.admin_master')
@section('admin')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Email Management</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{route('user.email.view')}}">Email Management</a></li>
                            <li class="breadcrumb-item active">Edit</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit <?= ucwords(str_replace('_', ' ', $data->key)) ?> Email</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{ route('user.email.update',$data->id) }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title" class="form-control" value="{{$data->title}}" required>
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Template<span style="color:red;font-size: 120%;">*</span>
                                                    <span title="User/Partner Name">{Name},</span> 
                                                    <span title="Company Name">{Company},</span> 
                                                    <span title="Country Name">{Country},</span> 
                                                    <span title="State Name">{State},</span> 
                                                    <span title="City Name">{City},</span> 
                                                    <span title="Address">{Address},</span> 
                                                    <span title="Pincode">{Pincode},</span> 
                                                    <span title="Email Address">{Email},</span> 
                                                    <span title="International Calling Code">{CallingCode},</span> 
                                                    <span title="Phone Number">{Phone},</span> 
                                                    <span title="Current Date">{Date},</span>
                                                    {{-- <span title="User Email Varification Link generate">{Link},</span> --}}
                                                    <span title="One-time password">{Otp},</span>
                                                    <span title="Subscription Name/LOB Name">{SubscriptionName},</span> 
                                                    <span title="Plan Name (Free-Trial/Basic/Advance/Ecommerce)">{PlanName},</span> 
                                                    <span title="Subscription End Date">{FutureDate},</span> 
                                                    <span title="Subscription Start Date">{CurrentDate},</span> 
                                                    <span title="International Currency Code">{CurrencyCode},</span> 
                                                    <span title="Grand Amount">{Amount},</span> 
                                                    <span title=" (15 days/QTR/MTH/YLY)">{PlanDuration},</span> 
                                                    <span title="Number of User in a Subscription">{NumberOfUser},</span> 
                                                    <span title="Event Name">{EventName},</span> 
                                                    <span title="Event Date">{EventDate},</span>
                                                    <span title="Event Description">{EventDescription},</span>
                                                    <span title="Event Zoom Meeting Link">{EventZoomLink},</span>
                                                    <span title="Event Zoom Meeting ID">{EventZoomID},</span>
                                                    <span title="Event Zoom Meeting Password">{EventZoomPassword},</span>
                                                    <span title="Payment Transaction Status(Success/Failure)">{TransactionStatus},</span> 
                                                    <span title="Payment Transaction ID">{TransactionID},</span> 
                                                    <span title="Payment Transaction Payment Mode (AuroPay/Offline)">{TransactionPaymentMode},</span> 
                                                    <span title="Subscription Purchase Address Line 1">{AddressLine1},</span> 
                                                    <span title="Subscription Purchase Address Line 2">{AddressLine2},</span> 
                                                    <span title="Subscription Purchase Industry Name">{Industry},</span> 
                                                    <span title="Subscription Purchase Designation">{Designation},</span> 
                                                    <span title="Subscription Purchase First Name">{ContactPersonFirstName},</span> 
                                                    <span title="Subscription Purchase Last Name">{ContactPersonLastName},</span> 
                                                    <span title="Subscription Purchase Email">{ContactPersonEmail},</span> 
                                                    <span title="Subscription Purchase Phone Number">{ContactPersonPhoneNo},</span> 
                                                    <span title="Customer Of Aurobees">{CustomerOf},</span> 
                                                    <span title="Subscription Purchase Company Code">{CompanyCode},</span> 
                                                    <span title="Subscription Purchase Plan Type (Free/Paid-Basic/Paid-Advance/Paid-E-commerce)">{PlanType},</span> 
                                                    <span title="Is Woocommerce Required (Yes/No)">{IsWoocommerceRequired},</span> 
                                                    <span title="Subscription Purchase Subscription Addons Name">{SubscriptionAddonsName}</span>
                                                    <span title="Subscription Status">{SubscriptionStatus}</span>
                                                </label>
                                                <textarea name="template" class="form-control" style="height:500px;" >{{$data->template}}</textarea>
                                                @error('template')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="exampleInputFile">File</label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="file" id="file">
                                                        <label class="custom-file-label">Choose File</label>
                                                    </div>
                                                </div>
                                                @error('file')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            @if(@$data->file)
                                                <div class="form-group">
                                                    <a href="{{url(@$data->file)}}" target="_blank">File</a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>


    <script type="text/javascript" src="{{url('tiny_mce/tiny_mce.js')}}"></script>
    <script type="text/javascript">

        tinyMCE.init({
            // General options
            mode : "textareas",
            theme : "advanced",
            plugins : "pagebreak,style,layer,table,save,advhr,advimage,advlink,emotions,iespell,inlinepopups,insertdatetime,preview,media,searchreplace,print,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template,wordcount,advlist,autosave",
            // Theme options
            theme_advanced_buttons1 : "save,newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
            theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,|,insertdate,inserttime,preview,|,forecolor,backcolor",
            theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,emotions,iespell,media,advhr,|,print,|,ltr,rtl,|,fullscreen",
            theme_advanced_buttons4 : "insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,visualchars,nonbreaking,template,pagebreak,restoredraft",
            theme_advanced_toolbar_location : "top",
            theme_advanced_toolbar_align : "left",
            theme_advanced_statusbar_location : "bottom",
            theme_advanced_resizing : true,

            relative_urls : false,
            remove_script_host : false,
            convert_urls : true,

            // Example content CSS (should be your site CSS)
            content_css : "css/content.css",
            // Style formats
            style_formats : [
                {title : 'Bold text', inline : 'b'},
                {title : 'Red text', inline : 'span', styles : {color : '#ff0000'}},
                {title : 'Red header', block : 'h1', styles : {color : '#ff0000'}},
                {title : 'Example 1', inline : 'span', classes : 'example1'},
                {title : 'Example 2', inline : 'span', classes : 'example2'},
                {title : 'Table styles'},
                {title : 'Table row 1', selector : 'tr', classes : 'tablerow1'}
            ],
             // Extended valid elements
             extended_valid_elements : "iframe[src|width|height|name|align|frameborder]",
            // Replace values for the template plugin
            template_replace_values : {
                username : "Some User",
                staffid : "991234"
            }
        });
    </script>
@endsection
