@php
    $header_title = 'Aurobees  | Latest News';
    $header_name = 'news';
    $page_name = 'news_management';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Latest News</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('latest-news.list') }}">Latest News</a></li>
                            <li class="breadcrumb-item">Edit</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Latest News</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{route('latest-news.update',$data->id)}}" enctype="multipart/form-data">
                                    <input type="hidden" name="old_image" value="{{@$data->image}}">
                                    <input type="hidden" name="old_video" value="{{@$data->video}}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="post_title" id="post_title" class="form-control"
                                                    placeholder="Title" value="{{$data->post_title}}" required>
                                                @error('post_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group slug-div">
                                                <label>Slug<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="post_slug" id="post_slug" class="form-control"
                                                    placeholder="Slug"  value="{{$data->post_slug}}" readonly>
                                                @error('post_slug')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            @if($defaultLanguagePagesList)
                                                <div class="form-group select-language-page-div">
                                                    <label>Select Page<span style="color:red;font-size: 120%;">*</span></label>
                                                    <select name="default_language_page" id="default_language_page" class="form-control">
                                                        @foreach ($defaultLanguagePagesList as $value)
                                                            <option value="{{ $value->id }}" {{$value->id==$data->default_language_page?'selected':''}}>{{ $value->post_title }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('default_language_page')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif
                                            <div class="form-group form-default">
                                                <label>Content<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="post_content" id="post_content" class="form-control">{{$data->post_content}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('post_content')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Location<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="location" id="location" class="form-control"
                                                    placeholder="Location"  value="{{$data->location}}" required >
                                                @error('location')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Key<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_key" id="meta_key" class="form-control"
                                                    placeholder="Meta Key"  value="{{$data->meta_key}}" >
                                                @error('meta_key')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_title" id="meta_title" class="form-control"
                                                    placeholder="Meta Title"  value="{{$data->meta_title}}" >
                                                @error('meta_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Description<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_description" id="meta_description" class="form-control"
                                                    placeholder="Meta Description"  value="{{$data->meta_description}}" >
                                                @error('meta_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            {{-- ---------------------------------------------------------------------------------------------- --}}
                                            <div class="form-group">
                                                <label>Type<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="media_type" class="form-control" id="media_type" required>
                                                    <option value="Image" {{$data->media_type=='Image'?'selected':''}}>Image</option>
                                                    <option value="Video" {{$data->media_type=='Video'?'selected':''}}>Video</option>
                                                </select>
                                                @error('media_type')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group image_div">
                                                <label for="exampleInputFile">Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image" id="image">
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1466 × 649 px</small>
                                                @error('image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group image_div">
                                                <img class="rounded-circle" id="showImage" style="width: 150px;height:150px;" src="{{(!empty($data->image))? url($data->image):url('image-placeholder.png')}}">
                                            </div>

                                            <div class="form-group video_div">
                                                <label>Video Type<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="video_type" id='video_type' class="form-control" onchange="VideoTypeChange()">
                                                    <option value="MP4" {{$data->video_type=='MP4'?'selected':''}}>MP4</option>
                                                    <option value="Youtube" {{$data->video_type=='Youtube'?'selected':''}}>Youtube</option>
                                                </select>
                                                @error('video_type')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group video_div video_mp4">
                                                <label for="exampleInputFile">Video<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="video" id="video">
                                                        <label class="custom-file-label">Choose Video</label>
                                                    </div>
                                                </div>
                                                @error('video')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group video_div video_mp4">
                                                <video width="150" controls>
                                                    @if($data->video)
                                                        <source src="{{url($data->video)}}" id="video_here">
                                                    @else
                                                        <source src="" id="video_here">
                                                    @endif
                                                </video>
                                            </div>
                                            <div class="form-group video_div youtube">
                                                <label>Youtube<span style="color:red;font-size: 120%;">*</span></label>
                                                <textarea name="youtube"  class="form-control">{{$data->youtube}}</textarea>
                                                @error('youtube')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            {{-- ------------------------------------------------------------------------------------------------- --}}

                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" class="form-control" required>
                                                    @foreach ($languages as $value)
                                                        @if($data->language=='en' && $value->code=='en')
                                                            <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                        @elseif ($data->language !='en' && $value->code !='en')
                                                            <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                        @endif
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Category<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="blog_category_id" id="category_id" class="form-control" required>
                                                    <option value="">Select</option>
                                                    @foreach($categorys as $key=> $category)
                                                        <option value="{{ $category->id }}" {{$category->id==$data->blog_category_id?'selected':''}}>{{ $category->name }}</option>
                                                    @endforeach;
                                                </select>
                                                @error('blog_category_id')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Status<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="post_status" class="form-control" required>
                                                    <option value="Published" {{$data->post_status=='Published'?'selected':''}} >Published</option>
                                                    <option value="Draft" {{$data->post_status=='Draft'?'selected':''}} >Draft</option>
                                                    <option value="Trash" {{$data->post_status=='Trash'?'selected':''}} >Trash</option>
                                                </select>
                                                @error('post_status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Date<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="date" name="created_at" class="form-control" value="{{date('Y-m-d',strtotime($data->created_at))}}" >
                                                @error('created_at')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label for="exampleInputFile">PDF</label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="pdf" id="pdf">
                                                        <label class="custom-file-label">Choose PDF</label>
                                                    </div>
                                                </div>
                                                @error('pdf')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            @if(@$data->pdf)
                                                <div class="form-group">
                                                    <a href="{{url(@$data->pdf)}}" target="_blank">PDF</a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('post_content');
    </script>
    <script>
        function VideoTypeChange(){
            var video_type=$('#video_type').val();
            if(video_type=='MP4'){
                $('.youtube').hide();
                $('.video_mp4').show();
            }else if(video_type=='Youtube'){
                $('.video_mp4').hide();
                $('.youtube').show();
            }
        }

        $(document).ready(function() {
            var media_type=$('#media_type').val();
            if(media_type=="Image"){
                $('.video_div').hide();
                $('.image_div').show();
            }else if(media_type=="Video"){
                $('.image_div').hide();
                $('.video_div').show();
                VideoTypeChange();
            }

            //image
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //video
            $(document).on("change", "#video", function(evt) {
                var $source = $('#video_here');
                $source[0].src = URL.createObjectURL(this.files[0]);
                $source.parent()[0].load();
            });
            //media_type
            $('#media_type').click(function(){
                if(this.value=="Image"){
                    $('.video_div').hide();
                    $('.image_div').show();
                }else if(this.value=="Video"){
                    $('.image_div').hide();
                    $('.video_div').show();
                    VideoTypeChange();
                }
            })
            //slug
            const post_title = document.querySelector('#post_title');
            post_title.addEventListener('keyup', function() {
                const inputString = $(this).val();
                const outputString = inputString.replace(/[^a-zA-Z0-9]/g, "-").replace(/\s+/g, "-");
                console.log(outputString);
                $('#post_slug').val(outputString);
            });
            $('#editSlug').click(function(){
                $('#post_slug').prop('disabled',false);
                $(this).hide();
            });

        });
        //language
        $('#language').on('change', function (e) {
            e.preventDefault();
            // $.ajax({
            //     type: 'get',
            //     url: "{{route('latest-news.getCategoryName')}}",
            //     data:{ code:$(this).val()},
            //     success: function (data) {
            //         $('#category_id').html('');
            //         if(data){
            //             data.forEach(element => {
            //                 $('#category_id').append(`<option value="${element['id']}">${element['name']}</option>`);
            //             });
            //         }
            //     }
            // });
            LanguageChangePage($(this).val());
        });
    </script>
    <script>
        $(document).ready(function() {
            @if($data->language=='en')
                $('.select-language-page-div').hide();
                $('.select-language-page-div select').prop('required', false);
            @else
                $('.slug-div').hide();
                $('.select-language-page-div select').prop('required', true);
            @endif
        });
        function LanguageChangePage(value){
            if(value=='en'){
                $('.select-language-page-div').hide();
                $('.select-language-page-div select').prop('required', false);
                $('.slug-div').show();
                $('.slug-div input').prop('required', true);
            }else{
                $('.slug-div').hide();
                $('.slug-div input').prop('required', false);
                $('.select-language-page-div').show();
                $('.select-language-page-div select').prop('required', true);
            }
        }
    </script>
@endsection

