@php
    $header_title = 'Aurobees  | Latest News';
    $header_name = 'news';
    $page_name = 'news_management';
@endphp
@extends('admin.admin_master')
@section('admin')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Latest News</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('latest-news.list') }}">Latest News</a></li>
                        <li class="breadcrumb-item">View</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">View Latest News Details</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table class="table table-striped">
                                <tbody>
                                    <tr>
                                        <th>Title</th>
                                        <td>{{$data->post_title}}</td>
                                   </tr>
                                    <tr>
                                        <th>Slug</th>
                                        <td>{{$data->post_slug}}</td>
                                   </tr>
                                   @if($data->blog_category_id)
                                        <tr>
                                            <th>Category</th>
                                            <td>{{$data['Category']['name']}}</td>
                                        </tr>
                                    @endif
                                   <tr>
                                        <th>Location</th>
                                        <td>{{$data->location}}</td>
                                   </tr>
                                   <tr>
                                        <th>Language</th>
                                        <td>{{$data['Language']['name']}}</td>
                                   </tr>
                                   <tr>
                                        <th>Date</th>
                                        <td>{{date('Y-m-d',strtotime($data->created_at))}}</td>
                                    </tr>
                                   <tr>
                                        <th>Type</th>
                                        <td>{{$data->media_type}}</td>
                                   </tr>
                                    @if($data->media_type=='Image')
                                        <tr>
                                            <th>Image</th>
                                            <td><img class="rounded-circle" style="width: 300px;" src="{{(!empty($data->image))? url($data->image):url('image-placeholder.png')}}"></td>
                                        </tr>
                                    @elseif ($data->media_type=='Video')
                                        <tr>
                                            <th>Video Type</th>
                                            <td>{{$data->video_type}}</td>
                                        </tr>
                                        @if ($data->video_type=='MP4')
                                            <th>Video</th>
                                            <td>
                                                <video width="300" controls>
                                                    <source src="{{url($data->video)}}" id="video_here">
                                                </video>
                                            </td>
                                        @else
                                            <th>Youtube</th>
                                            <td><iframe width="300" height="300" src="{{url($data->youtube)}}"></iframe></td>
                                        @endif
                                   @endif
                                    <tr>
                                        <th>Content</th>
                                        <td><?=@$data->post_content?></td>
                                    </tr>
                                    <tr>
                                        <th>Meta Title</th>
                                        <td>{{$data->meta_title}}</td>
                                    </tr>
                                    <tr>
                                        <th>Meta Key</th>
                                        <td>{{$data->meta_key}}</td>
                                    </tr>
                                    <tr>
                                        <th>Meta Description</th>
                                        <td>{{$data->meta_description}}</td>
                                    </tr>
                                    <tr>
                                        <th>Status</th>
                                        <td>{{$data->post_status}}</td>
                                    </tr>
                                </tbody>
                              </table>
                              <hr>
                              <center><a href="{{route('latest-news.list')}}" class="btn btn-round btn-primary">Back</a></center>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
