@php
    $header_title = 'Aurobees | Financial Service |Payment Gateway';
    $header_name = 'financial-service_management';
    $page_name = 'financial-service-payment-gateway';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Financial Service/Payment Gateway</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('financial-service.payment-gateway.list')}}">Payment Gateway</a></li>
                            <li class="breadcrumb-item active">Payment Gateway Edit</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Payment Gateway</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{ route('financial-service.payment-gateway.update',$data->id) }}" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="old_image_1" value="{{@$data->image_1}}">
                                    <input type="hidden" name="old_image_2" value="{{@$data->image_2}}">
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Title 1<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title_1" id="title" class="form-control" maxlength="20" placeholder="Title 1" value="{{$data->title_1}}" required>
                                                @error('title_1')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group slug-div">
                                                <label>Slug<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="slug" class="form-control" placeholder="Slug"  value="{{$data->slug}}" readonly>
                                                @error('slug')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            @if($defaultLanguagePagesList)
                                                <div class="form-group select-language-page-div">
                                                    <label>Select Page<span style="color:red;font-size: 120%;">*</span></label>
                                                    <select name="default_language_page" id="default_language_page" class="form-control">
                                                        @foreach ($defaultLanguagePagesList as $value)
                                                            <option value="{{ $value->id }}" {{$value->id==$data->default_language_page?'selected':''}}>{{ $value->title_1 }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('default_language_page')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif
                                            <div class="form-group">
                                                <label>Sub Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="sub_title" class="form-control" placeholder="Sub Title" maxlength="45" value="{{$data->sub_title}}" required>
                                                @error('sub_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Sub Sub Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="sub_sub_title" class="form-control" placeholder="Sub Sub Title" maxlength="45"  value="{{$data->sub_sub_title}}" required>
                                                @error('sub_sub_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Title 2<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title_2" class="form-control" placeholder="Title 2" maxlength="80" value="{{$data->title_2}}" required>
                                                @error('title_2')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="description" id="description" class="form-control" required>{{$data->description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Title 3<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title_3" class="form-control" placeholder="Title 3" maxlength="30"  value="{{$data->title_3}}" required>
                                                @error('title_3')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Button Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="button_text" class="form-control" placeholder="Button Text" maxlength="15" value="{{$data->button_text}}" required>
                                                @error('button_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Button Link<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="url" name="button_link" class="form-control" placeholder="Button Link"  value="{{$data->button_link}}" required>
                                                @error('button_link')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Key<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_key" id="meta_key" class="form-control"
                                                    placeholder="Meta Key"  value="{{$data->meta_key}}" required>
                                                @error('meta_key')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_title" id="meta_title" class="form-control"
                                                    placeholder="Meta Title"  value="{{$data->meta_title}}" required>
                                                @error('meta_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Description<span style="color:red;font-size: 120%;">*</span></label>
                                                <textarea name="meta_description" placeholder="Meta Description" class="form-control" required>{{$data->meta_description}}</textarea>
                                                @error('meta_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" id="language" class="form-control" required onchange="LanguageChangePage(this.value);">
                                                    @foreach ($languages as $value)
                                                        @if($data->language=='en' && $value->code=='en')
                                                            <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                        @elseif ($data->language !='en' && $value->code !='en')
                                                            <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                        @endif
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Status<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="status" class="form-control" required>
                                                    <option value="Published" {{$data->status=='Published'?'selected':''}} >Published</option>
                                                    <option value="Draft" {{$data->status=='Draft'?'selected':''}} >Draft</option>
                                                    <option value="Trash" {{$data->status=='Trash'?'selected':''}} >Trash</option>
                                                </select>
                                                @error('status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Image 1</label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image_1" id="image_1">
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1920 × 774 px</small>
                                                @error('image_1')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="image_1_showImage" style="max-width: 150px;max-height:150px;" src="{{(!empty($data->image_1))? url($data->image_1):url('image-placeholder.png')}}">
                                            </div>
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Image 2</label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image_2" id="image_2">
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 759 × 539 px</small>
                                                @error('image_2')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="image_2_showImage" style="max-width: 150px;max-height:150px;" src="{{(!empty($data->image_2))? url($data->image_2):url('image-placeholder.png')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('description');
    </script>
    <script>
        $(document).ready(function() {
            //image 1
            $('#image_1').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#image_1_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //image 2
            $('#image_2').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#image_2_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            @if($data->language=='en')
                $('.select-language-page-div').hide();
                $('.select-language-page-div select').prop('required', false);
            @else
                $('.slug-div').hide();
                $('.select-language-page-div select').prop('required', true);
            @endif
        });
        function LanguageChangePage(value){
            if(value=='en'){
                $('.select-language-page-div').hide();
                $('.select-language-page-div select').prop('required', false);
                $('.slug-div').show();
                $('.slug-div input').prop('required', true);
            }else{
                $('.slug-div').hide();
                $('.slug-div input').prop('required', false);
                $('.select-language-page-div').show();
                $('.select-language-page-div select').prop('required', true);
            }
        }
    </script>
@endsection

