@php
    $header_title = 'Aurobees  | Go Online Management | Create Website';
    $header_name = 'go-online_management';
    $page_name = 'go-online-create-website';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Go Online/Create Website</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('go-online.create-website.list')}}">Create Website</a></li>
                            <li class="breadcrumb-item active">Edit Features</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Create Website Features</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                @if($errors->any())
                                    {!! implode('', $errors->all('<div>:message</div>')) !!}
                                @endif
                                <form method="POST" autocomplete="off" action="{{route('go-online.create-website.features.update',$id)}}" enctype="multipart/form-data">
                                    @csrf
                                    @php $j=0; $i=1000; @endphp
                                    @foreach ($datas as $data)
                                        <div class="row main-row">
                                            <div class="col-md-4">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                            <input type="text" name="row[{{$j}}][title]" id="title"  value="{{$data->title}}" maxlength="35" class="form-control" placeholder="Title"  required>
                                                            <input type="hidden" name="row[{{$j}}][old_id]"   value="{{$data->id}}" >
                                                            <input type="hidden" name="row[{{$j}}][old_image]"  value="{{$data->image}}" >
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group image_div">
                                                            <label for="exampleInputFile">Image</label>
                                                            <div class="input-group">
                                                                <div class="custom-file">
                                                                    <input type="file" class="custom-file-input image" name="row[{{$j++}}][image]">
                                                                    <label class="custom-file-label">Choose Image</label>
                                                                </div>
                                                            </div>
                                                            <small style="color:red;">Image Size should be 106 × 106 px</small>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <img class="rounded-circle showImage" id="showImage{{$i++}}" style="max-width: 150px;max-height:150px;" src="{{$data->image?url($data->image):url('image-placeholder.png')}}">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <center><button type="button" class="btn btn-danger" onclick="DeleteRow(this,{{$data->id}})">Delete</button></center>
                                            </div>
                                        </div>
                                    @endforeach
                                    <div id="row_add"></div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-round btn-link" onclick="AddRow()">Add Row</button>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')


    <script>
        function AddRow(){
            let x = Math.floor((Math.random() * 100) + 1);
            let data=`<div class="row main-row">
                        <div class="col-md-4">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                        <input type="text" name="row[${x}][title]" id="title" class="form-control" maxlength="35" placeholder="Title"  required>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group image_div">
                                        <label for="exampleInputFile">Image</label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input image" name="row[${x}][image]">
                                                <label class="custom-file-label">Choose Image</label>
                                            </div>
                                        </div>
                                        <small style="color:red;">Image Size should be 106 × 106 px</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <img class="rounded-circle showImage" id="showImage${x}"  style="max-width: 150px;max-height:150px;" src="{{url('image-placeholder.png')}}">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <center><button class="btn btn-danger" onclick="$(this).closest('.row).remove();">Delete</button></center>
                        </div>
                    </div>`;
            $('#row_add').append(data);
            $('.image').change(function(e) {
                let id= $(this).closest('.row').find("div:nth-child(2) .showImage").attr('id');
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#'+id).attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        }

        $('.image').change(function(e) {
            let id= $(this).closest('.row').find("div:nth-child(2) .showImage").attr('id');
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#'+id).attr('src', e.target.result);
            }
            reader.readAsDataURL(e.target.files['0']);
        });

        function DeleteRow(th,id){
            $.ajax({
                type: 'post',
                url: "{{route('go-online.create-website.features.delete')}}",
                data:{
                    id:id,
                    _token:$("[name='_token']").val()
                },
                success: function (data) {
                    $(th).closest('.main-row').remove();
                }
            });
        }

    </script>
@endsection

