@php
    $header_title = 'Aurobees  | Home Page Management | Industries';
    $header_name = 'home_management';
    $sub_header_name='home_industries';
    $page_name = 'home_industries';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Industries</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{route('home.industries.list')}}">Industries</a></li>
                            <li class="breadcrumb-item active">Edit Industries</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Industries</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{route('home.industries.update',$data->id)}}" enctype="multipart/form-data">
                                    <input type="hidden" name="old_image" value="{{@$data->image}}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title" id="title" class="form-control" maxlength="25"
                                                    placeholder="Title" value="{{$data->title}}" required>
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="description" id="description" maxlength="170" class="form-control" required>{{$data->description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Button Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="button_text" class="form-control" maxlength="15"
                                                    placeholder="Button Text"  value="{{$data->button_text}}" required>
                                                @error('button_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Button Link<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="url" name="button_link" class="form-control"
                                                    placeholder="Button Link"  value="{{$data->button_link}}" required>
                                                @error('button_link')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" class="form-control" required>
                                                    @foreach ($languages as $value)
                                                        <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Status<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="status" class="form-control" required>
                                                    <option value="Published" {{$data->status=='Published'?'selected':''}} >Published</option>
                                                    <option value="Draft" {{$data->status=='Draft'?'selected':''}} >Draft</option>
                                                    <option value="Trash" {{$data->status=='Trash'?'selected':''}} >Trash</option>
                                                </select>
                                                @error('status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            {{-- ---------------------------------------------------------------------------------------------- --}}

                                            <div class="form-group">
                                                <label for="exampleInputFile">Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image" id="image">
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 225 × 225 px</small>
                                                @error('image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="showImage" style="width: 150px;height:150px;" src="{{(!empty($data->image))? url($data->image):url('image-placeholder.png')}}">
                                            </div>

                                            {{-- ------------------------------------------------------------------------------------------------- --}}
                                        </div>
                                    </div>
                                    <hr>
                                    <center>
                                        <input type="submit" value="Submit" class="btn btn-round btn-primary">
                                        <a href="{{route('home.industries.list')}}" class="btn btn-round btn-link">Back</a>
                                    </center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('description');
    </script>
    <script>
        $(document).ready(function() {
            //image
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        });
    </script>
@endsection

