@php
    $header_title = 'Aurobees  | Home Page Management | Our Services';
    $header_name = 'home_management';
    $sub_header_name='home_our-service';
    $page_name = 'home_our-services';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Our Services</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{route('home.our-services.list')}}">Our Services</a></li>
                            <li class="breadcrumb-item active">Edit Our Services Links</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Our Services Links</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                @if($errors->any())
                                    {!! implode('', $errors->all('<div>:message</div>')) !!}
                                @endif
                                <form method="POST" autocomplete="off" action="{{route('home.our-services.link.update',$id)}}" enctype="multipart/form-data">
                                    @csrf
                                    @php $j=0; $i=1000; @endphp
                                    @foreach ($datas as $data)
                                        <div class="row main-row">
                                            <div class="col-md-4">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                            <input type="text" name="row[{{$j}}][title]" id="title"  value="{{$data->title}}" maxlength="35" class="form-control" placeholder="Title"  required>
                                                            <input type="hidden" name="row[{{$j}}][old_id]"   value="{{$data->id}}" >
                                                            <input type="hidden" name="row[{{$j}}][old_icon]"  value="{{$data->icon}}" >
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label>Link<span style="color:red;font-size: 120%;">*</span></label>
                                                            <input type="url" name="row[{{$j}}][link]" id="link"  value="{{$data->link}}" class="form-control" placeholder="link"  required>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group image_div">
                                                            <label for="exampleInputFile">Icon</label>
                                                            <div class="input-group">
                                                                <div class="custom-file">
                                                                    <input type="file" class="custom-file-input image" name="row[{{$j++}}][icon]">
                                                                    <label class="custom-file-label">Choose Icon</label>
                                                                </div>
                                                            </div>
                                                            <small style="color:red;">Icon Size should be 50 × 50 px</small>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <img class="rounded-circle showImage" id="showImage{{$i++}}" style="max-width: 50px;max-height:50px;" src="{{$data->icon?url($data->icon):url('image-placeholder.png')}}">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <center><button type="button" class="btn btn-danger" onclick="DeleteRow(this,{{$data->id}})">Delete</button></center>
                                            </div>
                                        </div>
                                    @endforeach
                                    <div id="row_add"></div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-round btn-link" onclick="AddRow()">Add Row</button>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')


    <script>
        function AddRow(){
            let x = Math.floor((Math.random() * 100) + 1);
            let data=`<div class="row main-row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                        <input type="text" name="row[${x}][title]" id="title" class="form-control" maxlength="35" placeholder="Title"  required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Link<span style="color:red;font-size: 120%;">*</span></label>
                                        <input type="url" name="row[${x}][link]" id="link"  value="{{$data->link}}" class="form-control" placeholder="link"  required>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group image_div">
                                        <label for="exampleInputFile">Icon</label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input image" name="row[${x}][icon]">
                                                <label class="custom-file-label">Choose Icon</label>
                                            </div>
                                        </div>
                                        <small style="color:red;">Icon Size should be 50 × 50 px</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <img class="rounded-circle showImage" id="showImage${x}"  style="max-width: 50px;max-height:50px;" src="{{url('image-placeholder.png')}}">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <center><button class="btn btn-danger" onclick="$(this).closest('.main-row').remove();">Delete</button></center>
                        </div>
                    </div>`;
            $('#row_add').append(data);
            $('.image').change(function(e) {
                let id= $(this).closest('.row').find(".showImage").attr('id');
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#'+id).attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        }

        $('.image').change(function(e) {
            let id= $(this).closest('.row').find("div:nth-child(2) .showImage").attr('id');
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#'+id).attr('src', e.target.result);
            }
            reader.readAsDataURL(e.target.files['0']);
        });

        function DeleteRow(th,id){
            $.ajax({
                type: 'post',
                url: "{{route('home.our-services.link.delete')}}",
                data:{
                    id:id,
                    _token:$("[name='_token']").val()
                },
                success: function (data) {
                    $(th).closest('.main-row').remove();
                }
            });
        }
    </script>
@endsection

