@php
    $header_title = 'Aurobees  | Home Page Management | Slider';
    $header_name = 'home_management';
    $page_name = 'home_slider';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Slider</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{route('home.slider.list')}}">Slider</a></li>
                            <li class="breadcrumb-item active">Add Slider</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Add Slider</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{ route('home.slider.store') }}"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title" id="title" class="form-control" maxlength="25" placeholder="Title" value="{{old('title')}}" required>
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="description" id="description" class="form-control" maxlength="150" required>{{old('description')}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="text" class="form-control" placeholder="Key Offerings Text" maxlength="25"  value="{{old('text')}}" required>
                                                @error('text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="row">
                                                <div class="col-12 add-row">
                                                    <div class="row form-group">
                                                        <div class="col-5">
                                                            <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                        </div>
                                                        <div class="col-6">
                                                            <label>Link<span style="color:red;font-size: 120%;">*</span></label>
                                                        </div>
                                                        <div class="col-1">
                                                            <label>Action</label>
                                                        </div>
                                                    </div>
                                                    <div class="row form-group">
                                                        <div class="col-5">
                                                            <input type="text" name="child_title[]" placeholder="Enter Title" maxlength="30" required class="form-control">
                                                        </div>
                                                        <div class="col-6">
                                                            <input type="text" name="child_link[]" placeholder="Enter Link" required class="form-control">
                                                        </div>
                                                        <div class="col-1">
                                                            <button type="button" class="btn btn-round btn-danger" onclick="$(this).closest('.row').remove();">Delete</button>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <button type="button" class="btn btn-round btn-link" id="addRow">Add Row</button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" class="form-control" required>
                                                    @foreach ($languages as $value)
                                                        <option value="{{ $value->code }}">{{ $value->name }}</option>
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Icon<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="icon" id="icon" required>
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 92 × 118 px</small>
                                                @error('icon')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="icon_showImage" style="width: 150px;height:150px;" src="{{ url('image-placeholder.png') }}">
                                            </div>

                                            <div class="form-group">
                                                <label for="exampleInputFile">Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image" id="image">
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1920 × 1000 px</small>
                                                @error('image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="showImage" style="width: 150px;height:150px;" src="{{ url('image-placeholder.png') }}">
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('description');
    </script>
    <script>
        $(document).ready(function() {
            //image
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //header_icon
            $('#icon').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#icon_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });

            $('#addRow').on('click',function(){
                var data=`<div class="row form-group">
                        <div class="col-5">
                            <input type="text" name="child_title[]" placeholder="Enter Title" maxlength="30" required class="form-control">
                        </div>
                        <div class="col-6">
                            <input type="text" name="child_link[]" placeholder="Enter Link" required class="form-control">
                        </div>
                        <div class="col-1">
                            <button type="button" class="btn btn-round btn-danger" onclick="$(this).closest('.row').remove();">Delete</button>
                        </div>
                    </div>`;
                $('.add-row').append(data);
            });
        });
    </script>
@endsection

