@php
    $header_title = 'Aurobees  | Partner Page Management';
    $header_name = 'partner_management';
    $page_name = 'partner_page_management';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Partner Page Management</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('user.partner-page.view')}}">Partner Page Management</a></li>
                            <li class="breadcrumb-item active">Contract</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Contract Partner Page Management</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{route('user.partner-page-contract.update',$id)}}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Title</label>
                                                <input type="text" name="title" id="title" class="form-control" maxlength="30"
                                                    placeholder="Title" value="{{@$data->title}}" >
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group">
                                                <label>Sub Title</label>
                                                <input type="text" name="sub_title" class="form-control" maxlength="40"
                                                    placeholder="Sub Title"  value="{{@$data->sub_title}}" >
                                                @error('sub_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group">
                                                <label>Partner Contract Text</label>
                                                <input type="text" name="partner_contract_text" class="form-control"
                                                    placeholder="Partner Contract Text"  value="{{@$data->partner_contract_text}}" >
                                                @error('partner_contract_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Partner Contract Description </label>
                                                <textarea name="partner_contract_description" id="partner_contract_description" class="form-control">{{@$data->partner_contract_description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('partner_contract_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Benefits of Partnership Text</label>
                                                <input type="text" name="benefits_of_partnership_text" class="form-control"
                                                    placeholder="Benefits of Partnership Text"  value="{{@$data->benefits_of_partnership_text}}" >
                                                @error('benefits_of_partnership_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Benefits of Partnership Description </label>
                                                <textarea name="benefits_of_partnership_description" id="benefits_of_partnership_description" class="form-control">{{@$data->benefits_of_partnership_description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('benefits_of_partnership_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group">
                                                <label>Typical Benefits Text</label>
                                                <input type="text" name="typical_benefits_text" class="form-control" maxlength="40"
                                                    placeholder="Typical Benefits Text"  value="{{@$data->typical_benefits_text}}" >
                                                @error('typical_benefits_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            {{--Business  --}}
                                            <div class="form-group">
                                                <label>Business Text</label>
                                                <input type="text" name="business_text" class="form-control" maxlength="40"
                                                    placeholder="Business Text"  value="{{@$data->business_text}}" >
                                                @error('business_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Business Description 1 </label>
                                                <textarea name="business_description_1" id="business_description_1" class="form-control" >{{@$data->business_description_1}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('business_description_1')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Business Description 2 </label>
                                                <textarea name="business_description_2" id="business_description_2" class="form-control" >{{@$data->business_description_2}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('business_description_1')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            
                                            <div class="form-group">
                                                <label>Draft Agreement Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="draft_agreement_text" class="form-control"
                                                    placeholder="Draft Agreement Text"  value="{{@$data->draft_agreement_text}}" required>
                                                @error('draft_agreement_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Draft Agreement Checkbox Text<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="draft_agreement_checkbox_text" id="draft_agreement_checkbox_text" class="form-control" >{{@$data->draft_agreement_checkbox_text}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('draft_agreement_checkbox_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Contract Verification Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="contract_verification_description" id="contract_verification_description" class="form-control" >{{@$data->contract_verification_description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('contract_verification_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">

                                            <div class="form-group ">
                                                <label for="exampleInputFile">Banner Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="banner_image" id="banner_image" >
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1920 × 788 px</small>
                                                @error('banner_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="banner_image_showImage" style="width: 150px;height:150px;" src="{{(!empty($data->banner_image))? url($data->banner_image):url('image-placeholder.png')}}">
                                            </div>
                                            {{-- contract_page_image --}}
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Contract Page Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="contract_page_image" id="contract_page_image" >
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1920 × 788 px</small>
                                                @error('contract_page_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="contract_page_image_showImage" style="width: 150px;height:150px;" src="{{(!empty($data->contract_page_image))? url($data->contract_page_image):url('image-placeholder.png')}}">
                                            </div>

                                            
                                            {{-- image --}}
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Contract Verification Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="contract_verification_image" id="image" >
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 357 × 354 px</small>
                                                @error('contract_verification_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="image_showImage" style="width: 150px;height:150px;" src="{{(!empty($data->contract_verification_image))? url($data->contract_verification_image):url('image-placeholder.png')}}">
                                            </div>
                                            {{-- pdf --}}
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Draft Agreement<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="draft_agreement" id="draft_agreement" >
                                                        <label class="custom-file-label">Choose File</label>
                                                    </div>
                                                </div>
                                                @error('draft_agreement')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                @if (!empty($data->draft_agreement))
                                                    <a href="{{url($data->draft_agreement)}}" target="_blank" rel="noopener noreferrer">View Draft Agreement</a>
                                                @endif
                                            </div>

                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('partner_contract_description');
        CKEDITOR.replace('benefits_of_partnership_description');
        CKEDITOR.replace('business_description_1');
        CKEDITOR.replace('business_description_2');
        CKEDITOR.replace('draft_agreement_checkbox_text');
        CKEDITOR.replace('contract_verification_description');
    </script>
    <script>
        $(document).ready(function() {
            //image
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });

            //banner_image
            $('#banner_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#banner_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //contract_page_image
            $('#contract_page_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#contract_page_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //page_2_image
            $('#page_2_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#page_2_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //page_3_image
            $('#page_3_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#page_3_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //page_4_image
            $('#page_4_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#page_4_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //page_5_image
            $('#page_5_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#page_5_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //page_6_image
            $('#page_6_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#page_6_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //page_7_image
            $('#page_7_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#page_7_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        });
    </script>
@endsection

