@php
    $header_title = 'Aurobees  | Setting | Header Management';
    $header_name = 'setting_management';
    $page_name = 'setting_header';
@endphp
@extends('admin.admin_master')
@section('admin')
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Header Management</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="#">Setting</a></li>
                        <li class="breadcrumb-item active">Header Management</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Edit Footer Social Icons</h3>
                            <div style="float: right;">
                                <a href="{{route('setting.header.list')}}" class="btn btn-link">Back</a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <form action ="{{route('setting.header.footer-social-icons.store')}}" method="post" autocomplete="off" enctype="multipart/form-data">
                                @csrf
                                @php $j=0; $i=1000; @endphp
                                @foreach ($datas as $data)
                                    <div class="row main-row">
                                        <div class="col-md-6">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label>Link<span style="color:red;">*</span></label>
                                                        <input type="url" name="row[{{$j}}][link]" id="link" value="{{$data->link}}" class="form-control" placeholder="Link"  required>
                                                        <input type="hidden" name="row[{{$j}}][old_id]"   value="{{$data->id}}" >
                                                        <input type="hidden" name="row[{{$j}}][old_icon]"  value="{{$data->icon}}" >
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group image_div">
                                                <label for="exampleInputFile">Icon<span style="color:red;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input image" name="row[{{$j++}}][icon]">
                                                        <label class="custom-file-label">Choose Icon</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 30 × 30 px</small>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <img class="rounded-circle showImage" id="showImage{{$i++}}" style="width: 50px;height:50px;" src="{{$data->icon?url($data->icon):url('image-placeholder.png')}}">
                                        </div>
                                        <div class="col-md-2">
                                            <center><button type="button" class="btn btn-danger" onclick="DeleteRow(this,{{$data->id}})">Delete</button></center>
                                        </div>
                                    </div>
                                @endforeach
                                <div id="row_add"></div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <button type="button" class="btn btn-round btn-link" onclick="AddRow()">Add Row</button>
                                    </div>
                                </div>

                                <hr>
                                <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                            </form>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
@section('script')
<script>
    function AddRow(){
        let x = Math.floor((Math.random() * 100) + 1);
        let data=`<div class="row main-row">
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Link<span style="color:red;">*</span></label>
                                    <input type="url" name="row[${x}][link]" id="link" class="form-control" placeholder="Link"  required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group image_div">
                            <label for="exampleInputFile">Icon<span style="color:red;">*</span></label>
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input image" name="row[${x}][icon]" required>
                                    <label class="custom-file-label">Choose Image</label>
                                </div>
                            </div>
                            <small style="color:red;">Image Size should be 30 × 30 px</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <img class="rounded-circle showImage" id="showImage${x}"  style="width: 50px;height:50px;" src="{{url('image-placeholder.png')}}">
                    </div>
                    <div class="col-md-2">
                        <center><button class="btn btn-danger" onclick="$(this).closest('.main-row').remove();">Delete</button></center>
                    </div>
                </div>`;
        $('#row_add').append(data);

        $('.image').change(function(e) {
            let id= $(this).closest('.row').find(".showImage").attr('id');
            console.log(id);
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#'+id).attr('src', e.target.result);
            }
            reader.readAsDataURL(e.target.files['0']);
        });
    }

    $('.image').change(function(e) {
        let id= $(this).closest('.row').find(".showImage").attr('id');
        console.log(id);
        var reader = new FileReader();
        reader.onload = function(e) {
            $('#'+id).attr('src', e.target.result);
        }
        reader.readAsDataURL(e.target.files['0']);
    });

    function DeleteRow(th,id){
        $.ajax({
            type: 'post',
            url: "{{route('setting.header.footer-social-icons.delete')}}",
            data:{
                id:id,
                _token:$("[name='_token']").val()
            },
            success: function (data) {
                $(th).closest('.main-row').remove();
            }
        });
    }

</script>
@endsection
