@php
    $header_title = 'Aurobees  | Setting | Header Management';
    $header_name = 'setting_management';
    $page_name = 'setting_header';
@endphp
@extends('admin.admin_master')
@section('admin')
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Header Management</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="#">Setting</a></li>
                        <li class="breadcrumb-item active">Header Management</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit {{$parentMenu->title}} / {{$parentMenuChild->title}} Menu</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{ route('setting.header.header-menu-price-child.update',[$parentMenu->id, $parentMenuChild->id, $data->id]) }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Select {{$parentMenu->title}} Page</label>
                                                <select name="page" class="form-control">
                                                    <option value="">Select {{$parentMenu->title}} Page</option>
                                                    @if(!empty($table_1_datas))
                                                        @foreach ($table_1_datas as $child)
                                                            <option value="{{$child->id.'#'.$table_1_name}}" @if($data->table_id==$child->id) selected @endif >{{$child->title}}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                                @error('page')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title" class="form-control" placeholder="Title" value="{{$data->title}}" required>
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Link</label>
                                                <input type="text" name="link" class="form-control" placeholder="Link" value="{{$data->link}}" >
                                                @error('link')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Description<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="description" class="form-control" placeholder="Description" value="{{$data->description}}" required >
                                                @error('description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                        </div>
                                        <div class="col-md-3">

                                            <div class="form-group image_div">
                                                <label for="exampleInputFile">Icon</label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="icon" id="image" >
                                                        <label class="custom-file-label">Choose Icon</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 35 × 35 px</small>
                                                @error('icon')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group image_div">
                                                <img class="rounded-circle" id="showImage" style="width: 50px;height:50px;" src="{{($data->icon)? url($data->icon) : url('image-placeholder.png') }}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6"><label>Title/Description<span style="color:red;">*</span></label></div>
                                        <div class="col-md-4"><label>Language<span style="color:red;">*</span></label></div>
                                        <div class="col-md-2"><label>Action</label></div>
                                    </div>
                                    <div class="add-language-row">
                                        @if (!$languageTitles->isEmpty())
                                        @foreach($languageTitles as $item)
                                            <div class="row main-row">
                                                <div class="col-6">
                                                    <div class="form-group">
                                                        <input type="text" name="language_title[]" value="{{$item->title}}" class="form-control" placeholder="Title" required>
                                                        <input type="text" name="language_description[]" value="{{$item->description}}" class="form-control" placeholder="Description" required>
                                                    </div>
                                                </div>
                                                <div class="col-4">
                                                    <div class="form-group">
                                                        <select class="form-control" required name="language[]">
                                                            @foreach ($languages as $value)
                                                                @if($value->code!='en')
                                                                    <option value="{{ $value->code }}" {{($value->code==$item->language)?'selected':''}}>{{ $value->name }}</option>
                                                                @endif
                                                            @endforeach;
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-2">
                                                    <center><button class="btn btn-danger" onclick="$(this).closest('.main-row').remove();">Delete</button></center>
                                                </div>
                                            </div>
                                        @endforeach
                                        @endif
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-round btn-link" onclick="AddRow()">Add Row</button>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function() {
            //image
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        });
        function AddRow(){
            data=`<div class="row main-row">
                <div class="col-6">
                    <div class="form-group">
                        <input type="text" name="language_title[]" class="form-control" placeholder="Title" required>
                        <input type="text" name="language_description[]" class="form-control" placeholder="Description" required>
                    </div>
                </div>
                <div class="col-4">
                    <div class="form-group">
                        <select class="form-control" required name="language[]">
                            @foreach ($languages as $value)
                                @if($value->code!='en')
                                    <option value="{{ $value->code }}" >{{ $value->name }}</option>
                                @endif
                            @endforeach;
                        </select>
                    </div>
                </div>
                <div class="col-2">
                    <center><button class="btn btn-danger" onclick="$(this).closest('.main-row').remove();">Delete</button></center>
                </div>
            </div>`;
            $('.add-language-row').append(data);
        }
    </script>
@endsection

