@php
$meta_title = 'Aurobees | Billing';
$meta_description = '';
$meta_keywords = '';
$add_class_header='show-nav';
$footer_sign_up_for_free_trial=true;
$parent_active_page='customer-management';
$active_page='customer-billing';
@endphp
@extends('frontend.user.includes.master')
@section('body')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">

<div class="dashboard_bg">
    <section class="usr_dashboard_user">
        <div class="container">
            <div class="row">
                <div class="col-md-3"></div>
                <div class="col-md-9">
                    <div class="usr_dashboard_title">
                        <h1>Billing</h1>
                        <div class="d-flex">
                            <div class="log_out_btn">
                                <a href="javascript:void(0);" onclick="$('#logout-form').submit();">Log Out</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    @include('frontend.become_a_partner.includes.body.sidebar')
                </div>
                <div class="col-md-9">
                    <div class="scroll_screen">
                        <div class="dashboard_right dashboard_subscriptions">
                            <div class="data_table_wrap">
                                <div class="table__strip">
                                    <div class="total_record">

                                    </div>
                                    <div class="download__list">
                                        <a href="{{route('partner.billing.excel')}}">Download</a>
                                    </div>
                                </div>
                                <table id="DataTable" class="table table-striped nowrap">
                                    <thead>
                                        <tr>
                                            <th>No</th>
                                            <th>Subscribe Billing No</th>
                                            <th>Company</th>
                                            <th>Name</th>
                                            <th>LOB Name</th>
                                            <th>LOB Type</th>
                                            <th>LOB Plan</th>
                                            <th>No. User</th>
                                            <th>Form Date</th>
                                            <th>Due Date</th>
                                            <th>Commission Amount</th>
                                            <th>Shared Amount</th>
                                            <th>Total Amount</th>
                                            <th>Status</th>
                                            <th>Paid Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if($datas)
                                            @foreach ($datas as $key => $data)
                                                <tr>
                                                    <td>
                                                        <div class="check_input">
                                                            <label for="">{{ $key + 1 }}</label>
                                                        </div>
                                                    </td>
                                                    <td>{{$data->serial_number}}</td>
                                                    <td>{{ $data->company }}</td>
                                                    <td>{{ $data->name }}</td>
                                                    <td>{{ $data->industry_title }}</td>
                                                    <td><?= @$data->plan_name ?></td>
                                                    <td><?=$data->plan_duration?></td>
                                                    <td><?=(@$data->plan_name=='Ecommerce')?1:@$data->quantity ?></td>
                                                    <td>{{ $data->start_at }}</td>
                                                    <td>{{ $data->end_at }}</td>
                                                    <td>{{$data->currency_code.' '. number_format($data->partner_commission_amount, 2) }}</td>
                                                    <td>{{$data->currency_code.' '. number_format($data->grand_amount - $data->partner_commission_amount, 2) }}</td>
                                                    <td>{{$data->currency_code.' '. number_format($data->grand_amount, 2) }}</td>
                                                    <td>@if($data->plan_name=='Free-Trial') Upgrade @else Paid @endif</td>
                                                    <td>{{ $data->start_at }}</td>

                                                    <td>
                                                        <a href="javascript:void(0);" onclick="viewDetailBilling('{{route('partner.billing.show',Crypt::encrypt($data->id))}}');"><i id="eyeIcon_table" class="fa fa-eye"></i></a>
                                                        <a href="{{route('partner.billing.pdf',Crypt::encrypt($data->id))}}"><img width="15" src="{{url('frontend/images/download-icon1.png')}}" alt="img"></a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('frontend.become_a_partner.includes.body.help-center-mobile')
        </div>
    </section>
</div>
{{-- model --}}
<div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Billing Details</h5>
                <button type="button" class="close" onclick="$('#exampleModalLong').modal('hide');" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body add-subscription-data">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary"
                    onclick="$('#exampleModalLong').modal('hide');">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script>
        $(document).ready(function () {
            new DataTable('#DataTable', {});
            $('.data_table_wrap .dataTables_wrapper table').wrap('<div class="scroll_table" />');
        });
        function viewDetailBilling(url) {
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('.add-subscription-data').html(response);
                    $('#exampleModalLong').modal('show');
                },
                error: function (xhr, status, error) {
                    AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);
                }
            });
        }
    </script>
@endsection
