@php
$meta_title = 'Aurobees | Customer';
$meta_description = '';
$meta_keywords = '';
$add_class_header='show-nav';
$footer_sign_up_for_free_trial=true;
$parent_active_page='customer-management';
$active_page='customer-customer';
@endphp
@extends('frontend.user.includes.master')
@section('body')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">

<div class="dashboard_bg">
    <section class="usr_dashboard_user">
        <div class="container">
            <div class="row">
                <div class="col-md-3"></div>
                <div class="col-md-9">
                    <div class="usr_dashboard_title">
                        <h1>Customers</h1>
                        <div class="d-flex">
                            <div class="log_out_btn">
                                <a href="javascript:void(0);" onclick="$('#logout-form').submit();">Log Out</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    @include('frontend.become_a_partner.includes.body.sidebar')
                </div>
                <div class="col-md-9">
                    <div class="scroll_screen">
                        <div class="dashboard_right dashboard_subscriptions">
                            <div class="data_table_wrap">
                                <div class="table__strip">
                                    <div class="total_record">

                                    </div>
                                    <div class="download__list">
                                        <a href="{{route('partner.customer.excel')}}">Download</a>
                                    </div>
                                </div>
                                <table id="DataTable" class="table table-striped nowrap">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Code</th>
                                            <th>Company</th>
                                            <th>First Name</th>
                                            <th>Last Name</th>
                                            <th>Email</th>
                                            <th>Created</th>
                                            <th>Active</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if($datas)
                                            @foreach ($datas as $key => $data)
                                                <tr>
                                                    <td>{{$key+1}}</td>
                                                    <td>{{$data->code}}</td>
                                                    <td>{{$data->company}}</td>
                                                    <td>{{$data->f_name}}</td>
                                                    <td>{{$data->l_name}}</td>
                                                    <td>{{$data->email}}</td>
                                                    <td>{{date('Y-m-d H:i:s', strtotime($data->created_at))}}</td>
                                                    <td>{{$data->is_email_verified == 1 ? 'Yes' : 'No'}}</td>

                                                    <td>
                                                        <a onclick="viewDetailBilling(`{{route('partner.customer.edit', $data->id)}}`)" ><i class="fas fa-edit"></i></a>
                                                        <a onclick="viewDetailBilling(`{{route('partner.customer.show',$data->id)}}`)"  ><i class="fas fa-eye"></i></a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('frontend.become_a_partner.includes.body.help-center-mobile')
        </div>
    </section>
</div>
{{-- model --}}
<div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Customer Details</h5>
                <button type="button" class="close" onclick="$('#exampleModalLong').modal('hide');" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body add-subscription-data">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary"
                    onclick="$('#exampleModalLong').modal('hide');">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script>
        $(document).ready(function () {
            new DataTable('#DataTable', {});
            $('.data_table_wrap .dataTables_wrapper table').wrap('<div class="scroll_table" />');
        });
        function viewDetailBilling(url) {
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('.add-subscription-data').html(response);
                    $('#exampleModalLong').modal('show');
                },
                error: function (xhr, status, error) {
                    AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);
                }
            });
        }

        function submitFormData() {
            var formData = $('#edit-user-form').serialize();
            
            $.ajax({
                type: 'POST',
                url: "{{ route('partner.customer.update') }}",
                data: formData,
                headers: { 
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    $('#exampleModalLong').modal('hide'); 
                    AlertMassage(response.message); 
                },
                error: function(xhr, status, error) {
                    AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);
                }
            });
        }
    </script>
@endsection
