@php
    $footer_sign_up_for_free_trial = true;
    $add_class_header = 'show-nav';
@endphp
@extends('frontend.user.includes.master')
@section('body')
    <section class="step_screen_wrap">
        <div class="container">
            <div class="step__title">
                <h1><?=@$partner_page_data->title?></h1>
            </div>
            <div class="form_border company_info__form">
                <div class="left_grid">
                    <div class="number_list">
                        <ul>
                            <li><a href="{{route('become-a-partner.login-information')}}">1</a></li>
                            <li><a href="{{route('become-a-partner.basic-information')}}">2</a></li>
                            <li class="active">3</li>
                            <li><a href="{{route('become-a-partner.company-financial-information')}}">4</a></li>
                            <li><a href="{{route('become-a-partner.company-financial-information2')}}">5</a></li>
                            <li><a href="{{route('become-a-partner.company-documents-upload')}}">6</a></li>
                            {{-- <li><a href="{{route('become-a-partner.thank-you')}}">7</a></li> --}}
                            <li><a href="{{route('become-a-partner.profile-verification-summary')}}">7</a></li>
                            <li><a href="{{route('become-a-partner.partner-contract')}}">8</a></li>
                            <li><a href="{{route('become-a-partner.contract-verification')}}">9</a></li>
                        </ul>
                    </div>
                    <div class="form_grid_inner">
                        <div class="left_title">
                            <h2>{{ HelperServiceProvider::GetLanguageText('company_information')}}</h2>
                        </div>
                        <form name="patner_registration" action="{{route('become-a-partner.company-information.store')}}"  method="POST" autocomplete="off">
                            @csrf
                            <div class="form_group">
                                <div class="form_feild">
                                    <input type="text" name="company" id="company" value="{{PartnerRegistrationProvider::PartnerRegistration('company')}}" maxlength="100" placeholder="{{ HelperServiceProvider::GetLanguageText('company_name')}}*">
                                </div>
                            </div>
                            <div class="flex_grid">
                                <div class="form_group">
                                    <div class="form_feild">
                                        @php $country=PartnerRegistrationProvider::PartnerRegistration('country'); @endphp
                                        <select class="country-select AllCounteryList" name="country" id="country" ></select>
                                        <label id="country-error-div" style="display: none;" class="error" for="country">Please select country name</label>
                                        @error('country')
                                            <span class="text-danger error-country">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form_group"  id="state_div">
                                    <div class="form_feild">
                                        @php $stateName=PartnerRegistrationProvider::PartnerRegistration('state'); @endphp
                                        <select name="statelist" class="form-control" id="statelist" >
                                            <option value="">Please Select State</option>
                                            @foreach ($state_list as $state)
                                                <option value="{{$state->code}}">{{$state->name}}</option>
                                            @endforeach
                                        </select>
                                        @error('statelist')
                                            <span class="text-danger error-statelist">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form_group">
                                    <div class="form_feild">
                                        <input type="text" placeholder="{{ HelperServiceProvider::GetLanguageText('city')}}*" value="{{PartnerRegistrationProvider::PartnerRegistration('city')}}" name="city" id="city" maxlength="50">
                                        @error('city')
                                            <span class="text-danger error-city">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="form_group">
                                <div class="form_feild">
                                    <input type="text" placeholder="{{ HelperServiceProvider::GetLanguageText('address_line_1')}}*" value="{{PartnerRegistrationProvider::PartnerRegistration('address')}}" name="address" id="address" maxlength="100" >
                                    @error('address')
                                        <span class="text-danger error-address">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group">
                                <div class="form_feild">
                                    <input type="text" placeholder="{{ HelperServiceProvider::GetLanguageText('address_line_2')}}*" value="{{PartnerRegistrationProvider::PartnerRegistration('address_2')}}" name="address_2" id="address_2" maxlength="100" >
                                    @error('address_2')
                                        <span class="text-danger error-address">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="flex_grid phone_zipcode">
                                <div class="form_group pincode-div">
                                    <div class="form_feild">
                                        <input type="text" placeholder="{{ HelperServiceProvider::GetLanguageText('pincode_zipcode')}}*" value="{{PartnerRegistrationProvider::PartnerRegistration('pincode')}}" name="pincode" id="pincode"  >
                                        @error('pincode')
                                            <span class="text-danger error-pincode">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form_group">
                                    <div class="form_feild">
                                        @php $company_calling_code=PartnerRegistrationProvider::PartnerRegistration('company_calling_code') @endphp
                                        <input type="hidden" name="company_calling_code" class="company_calling_code" value="{{$company_calling_code}}" id="company_calling_code">
                                        <input type="text" value="{{PartnerRegistrationProvider::PartnerRegistration('company_phone')}}" class="form-control" placeholder="{{ HelperServiceProvider::GetLanguageText('contact_number')}}*" maxlength="15" name="company_phone" id="company_phone">
                                        <span class="text-danger error-calling_code">Please enter International Calling code.</span>
                                        @error('company_phone')
                                            <span class="text-danger error-phone">{{ $message }}</span>
                                        @enderror
                                        @error('company_calling_code')
                                            <span class="text-danger error-calling-code">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="form_group">
                                <div class="form_feild">
                                    <input type="text" placeholder="{{ HelperServiceProvider::GetLanguageText('what_is_your_primary_business_domain_focus?')}}*"  value="{{PartnerRegistrationProvider::PartnerRegistration('what_is_your_primary_business_domain_focus')}}" name="what_is_your_primary_business_domain_focus" id="what_is_your_primary_business_domain_focus"  maxlength="20">
                                    @error('what_is_your_primary_business_domain_focus')
                                        <span class="text-danger error-what_is_your_primary_business_domain_focus">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group">
                                <div class="form_feild">
                                    <input type="text" name="primary_company_website_or_social_media_page" value="{{PartnerRegistrationProvider::PartnerRegistration('primary_company_website_or_social_media_page')}}" id="primary_company_website_or_social_media_page" placeholder="{{ HelperServiceProvider::GetLanguageText('primary_company_website_or_social_media_page')}}*"  maxlength="50">
                                    @error('primary_company_website_or_social_media_page')
                                        <span class="text-danger error-primary_company_website_or_social_media_page">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group">
                                <div class="form_feild">
                                    <p>{{ HelperServiceProvider::GetLanguageText('provide_a_short_description_of_your_company')}}</p>
                                    <p>{{ HelperServiceProvider::GetLanguageText('note_that_these_details_may_be_used')}}</p>
                                    <textarea name="short_description_of_your_company"  maxlength="500" id="short_description_of_your_company" cols="30" rows="5" placeholder="{{ HelperServiceProvider::GetLanguageText('short_description')}}*">{{PartnerRegistrationProvider::PartnerRegistration('short_description_of_your_company')}}</textarea>
                                    @error('short_description_of_your_company')
                                        <span class="text-danger error-short_description_of_your_company">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_btn_grid">
                                <button type="submit" class="btn_cta">{{ HelperServiceProvider::GetLanguageText('save_and_next')}}</button>
                                <button type="reset" class="btn_cta">{{ HelperServiceProvider::GetLanguageText('clear_all')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="right_grid">
                    <div class="right_gray_bg basice_information company_info">
                        <div class="right__side_img">
                            <img src="{{url($partner_page_data->page_3_image)}}" alt="Company Information">
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('script')
<script>
    $('.error-calling_code').hide();
    $('#state_div').hide();
    jQuery(function() {
        // Add custom validation method for country field
        $.validator.addMethod("validCountry", function (value) {
            if(value !== "-1"){
                $('#country-error-div').hide();
            }else{
                $('#country-error-div').show();
            }
            return value !== "-1";
        }, "Please select country name.");
        // Custom validation method for checking Calling Code
        $.validator.addMethod("CallingCode", function(value, element) {
            return ($('#company_calling_code').val())?true:false;
        }, "Please select Calling code.");
      jQuery("form[name='patner_registration']").validate({
        rules: {
            company:{
                required: true,
                maxlength:101,
                minlength:2
            },
            city:{
                required: true,
                maxlength:51
            },
            address:{
                required: true,
                maxlength:101
            },
            address_2:{
                required: true,
                maxlength:101
            },
            country: {
                validCountry: true
            },
            company_phone:{
                CallingCode:true,
                required:true,
                digits:true
            },
            pincode:{
                required:function() {
                    if($("#country").val()=='AE'){
                        return false;
                    }
                    return true;
                },
                digits:true
            },
            statelist:{required:
                function() {
                    if($("#country").val()=='IN'){
                        return true;
                    }
                    return false;
                }
            },
            what_is_your_primary_business_domain_focus:'required',
            primary_company_website_or_social_media_page:'required',
            short_description_of_your_company:'required'
        },
        // Specify validation error messages
        messages: {
          city:{
            maxlength: "City name must be less then 50 characters long.",
            required: "Please enter city name."
          },
          address:{
            maxlength: "address must be less then 100 characters long.",
            required: "Please enter address line 1."
          },
          address_2:{
            maxlength: "address must be less then 100 characters long.",
            required: "Please enter address line 2."
          },
          company:{
            required: "Please enter company name",
            maxlength: "Company name must be less then 100 characters long.",
            minlength: "Company name must be greater then 2 characters long."
          },
          country:"Please select country name",
          calling_code:{
            required:"Please enter International Calling code."
          },
          pincode: {
            required: "Please enter Pincode/Zipcode",
            minlength: "Pincode/Zipcode must be 6 digits long."
          },
          company_phone: {
            required: "Please enter phone number.",
            minlength: "Your phone number must be at least 10 digits long",
            maxlength: "Your phone number must be less or equal 15 digits long"
          },
          statelist : "Please Select State",
          what_is_your_primary_business_domain_focus : "Please enter What is your primary business domain focus",
          primary_company_website_or_social_media_page : "Please enter Primary Company Website or Social Media Page",
          short_description_of_your_company : "Please enter Short Description"
        },
        submitHandler: function(form) {
            form.submit();
        }
      });
    });
    function callingCodeSelect(countryCode){
        var countryCode = countryCode.toLowerCase();
        $('li.iti__country').each(function(){
            let country_code=$(this).data('country-code');
            if(countryCode==country_code){
                let dial_code=$(this).data('dial-code');
                let country_name=$(this).find('.iti__country-name').html();

                $('.company_calling_code').val(country_code);
                $('.iti__selected-dial-code').html('+'+dial_code);
                $('.iti__selected-flag').attr('title', country_name+' +'+dial_code);
                $('.iti__selected-flag .iti__flag').removeClass(function(index, className) {
                    return (className.match(/(^|\s)iti__\S+/g) || []).join(' ');
                }).addClass('iti__flag iti__' + country_code);

            }
        })
    }

    $('#country').change(function(){
        if($(this).val()=='AE'){
            $('.pincode-div').hide();
        }else{
            $('.pincode-div').show();
        }
        if($(this).val()=='IN'){
            $('#state_div').show();
        }else{
            $('#state_div').hide();
        }
        $('#country-error').hide();
        $('#country-error-div').hide();
        //------------------------------------------------------------------
        callingCodeSelect($(this).val());
        //------------------------------------------------------------------
    });
    //Dealer Name
    jQuery(document).on('keypress', '#company', function(event) {
        jQuery('.error-country').hide();
        $(this).css({'text-transform': 'capitalize'});
        var regex = new RegExp("^[a-zA-Z 0-9 .-]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key) && event.which !== 13) {
            event.preventDefault();
            return false;
        }
    });
    //Dealer Name
    jQuery(document).on('keypress', '#city', function(event) {
        jQuery('.error-city').hide();
        $(this).css({'text-transform': 'capitalize'});
        var regex = new RegExp("^[a-zA-Z 0-9 ,'-]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key) && event.which !== 13) {
            event.preventDefault();
            return false;
        }
        var phone_no=$('#city').val();
        if(phone_no.length>50){
            return false;
        }
    });
    //phone
    jQuery(document).on('keypress', '#pincode,#company_phone', function(event) {
        var regex = new RegExp("^[0-9]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key) && event.which !== 13) {
            event.preventDefault();
            return false;
        }
    });
    //Street  Address
    jQuery(document).on('keypress', '#address,#address_2,#what_is_your_primary_business_domain_focus,#short_description_of_your_company', function(event) {
        jQuery('.error-address').hide();
        $(this).css({'text-transform': 'capitalize'});
        var regex = new RegExp("^[a-zA-Z0-9 .' ,-]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key) && event.which !== 13) {
            event.preventDefault();
            return false;
        }
    });
    //calling code
    var intl=$('#company_phone').intlTelInput({
      initialCountry: "<?=($company_calling_code)?$company_calling_code:'auto'?>",
      separateDialCode: true,
    });
    // change calling code
    $('body').on('click keydown keypress touchstart pointerdown', '.iti__country.iti__standard', function() {
        var flagElement = $(this).find('.iti__flag').attr('class');
        var newText = flagElement.replace("iti__flag iti__", "");
        $('#company_calling_code').val(newText);
        console.log(newText);
        
    });
    @if(@$country)
        setTimeout(() => {
            $("#country").val("<?=@$country?>").change();
            $("#statelist").val("<?=@$stateName?>").change();
        }, 1000);
    @endif
    @if(!$company_calling_code)
        $(document).ready(function() {
            $('.iti__selected-flag .iti__flag').addClass('dummy-flag-icon');
        });
    @endif
</script>
@endsection
