@php
    $add_class_header = 'show-nav';
    $footer_sign_up_for_free_trial = true;
@endphp
@extends('frontend.user.includes.master')
@section('body')
    <section class="step_screen_wrap company-financial screen_six">
        <div class="container">
            <div class="step__title">
                <h1><?=@$partner_page_data->title?></h1>
            </div>
            <div class="form_border Financial__Info__form left left_side_profile">
                <div class="left_grid">
                    <div class="number_list">
                        <ul>
                            <li><a href="{{route('become-a-partner.login-information')}}">1</a></li>
                            <li><a href="{{route('become-a-partner.basic-information')}}">2</a></li>
                            <li><a href="{{route('become-a-partner.company-information')}}">3</a></li>
                            <li><a href="{{route('become-a-partner.company-financial-information')}}">4</a></li>
                            <li class="active">5</li>
                            <li><a href="{{route('become-a-partner.company-documents-upload')}}">6</a></li>
                            <!-- <li><a href="{{route('become-a-partner.thank-you')}}">7</a></li> -->
                            <li><a href="{{route('become-a-partner.profile-verification-summary')}}">7</a></li>
                            <li><a href="{{route('become-a-partner.partner-contract')}}">8</a></li>
                            <li><a href="{{route('become-a-partner.contract-verification')}}">9</a></li>
                        </ul>
                    </div>
                    <div class="form_grid_inner">
                        <div class="left_title profile_title">
                            <h2>{{ HelperServiceProvider::GetLanguageText('company_financial_information')}} </h2>
                        </div>
                        <form action="{{route('become-a-partner.company-financial-information2.store')}}" name="patner_registration"  method="POST" autocomplete="off">
                            @csrf
                            <div class="form_group full_label resp_spacing prof_spacing">
                                <label>{{ HelperServiceProvider::GetLanguageText('please_specify_the_number_of_employees_by_job_category')}}
                                    <br>{{ HelperServiceProvider::GetLanguageText('if_a_person_has_multiple_roles_count_them_in_one_category')}}</label>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('total_number_of_employees')}}</label>
                                <div class="form_feild">
                                    <input type="text" name="total_number_of_employees" value="{{PartnerRegistrationProvider::PartnerRegistration('total_number_of_employees')}}" id="total_number_of_employees" placeholder="">
                                    @error('total_number_of_employees')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('total_number_of_sales_employees')}}</label>
                                <div class="form_feild">
                                    <input type="text" name="total_number_of_sales_employees" value="{{PartnerRegistrationProvider::PartnerRegistration('total_number_of_sales_employees')}}" id="total_number_of_sales_employees" placeholder="">
                                    @error('total_number_of_sales_employees')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('total_number_of_services')}}</label>
                                <div class="form_feild">
                                    <input type="text" name="total_number_of_services" value="{{PartnerRegistrationProvider::PartnerRegistration('total_number_of_services')}}" id="total_number_of_services" placeholder="">
                                    @error('total_number_of_services')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('total_number_of_technical_support_employees')}}</label>
                                <div class="form_feild">
                                    <input type="text" name="total_number_of_technical_support_employees" value="{{PartnerRegistrationProvider::PartnerRegistration('total_number_of_technical_support_employees')}}" id="total_number_of_technical_support_employees" placeholder="">
                                    @error('total_number_of_technical_support_employees')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('total_number_of_marketing_employees')}}</label>
                                <div class="form_feild">
                                    <input type="text" name="total_number_of_marketing_employees" value="{{PartnerRegistrationProvider::PartnerRegistration('total_number_of_marketing_employees')}}" id="total_number_of_marketing_employees" placeholder="">
                                    @error('total_number_of_marketing_employees')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_btn_grid">
                                <button type="submit" class="btn_cta">{{ HelperServiceProvider::GetLanguageText('save_and_next')}}</button>
                                <button type="reset" class="btn_cta">{{ HelperServiceProvider::GetLanguageText('clear_all')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="right_grid right_side_profile">
                    <div class="right_gray_bg basice_information Financial-Information">
                        <div class="right__side_img">
                            <img src="{{url($partner_page_data->page_5_image)}}" alt="Financial-Information">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('script')
@endsection
