@php

    $add_class_header = 'show-nav';

    $footer_sign_up_for_free_trial = true;

@endphp

@extends('frontend.user.includes.master')

@section('body')

    <section class="step_screen_wrap company-financial screen_six">
        <div class="container">
            <div class="step__title">
                <h1><?=@$partner_page_data->title?></h1>
            </div>
            <div class="form_border Financial__Info__form left left_side_profile reg_verification">
                <div class="left_grid">
                    <div class="number_list">
                        <ul>
                            <li><a href="{{route('become-a-partner.login-information')}}">1</a></li>
                            <li><a href="{{route('become-a-partner.basic-information')}}">2</a></li>
                            <li><a href="{{route('become-a-partner.company-information')}}">3</a></li>
                            <li><a href="{{route('become-a-partner.company-financial-information')}}">4</a></li>
                            <li><a href="{{route('become-a-partner.company-financial-information2')}}">5</a></li>
                            <li><a href="{{route('become-a-partner.company-documents-upload')}}">6</a></li>
                            {{-- <li><a href="{{route('become-a-partner.thank-you')}}">7</a></li> --}}
                            <li class="active">7</li>
                            <li><a href="{{route('become-a-partner.partner-contract')}}">8</a></li>
                            <li><a href="{{route('become-a-partner.contract-verification')}}">9</a></li>
                        </ul>
                    </div>
                    <div class="form_grid_inner" style="padding-right: 0px">
                        <div class="left_title profile_title">
                            <h2>{{ HelperServiceProvider::GetLanguageText('profile_verification_summary')}} </h2>
                        </div>
                        <form action="">
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('partners_first_name')}}: <strong style="font-weight: bold">{{PartnerRegistrationProvider::PartnerRegistration('f_name')}}</strong></label>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('partners_last_name')}}: <strong style="font-weight: bold">{{PartnerRegistrationProvider::PartnerRegistration('l_name')}}</strong></label>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('company_name')}}: <strong style="font-weight: bold">{{PartnerRegistrationProvider::PartnerRegistration('company')}}</strong></label>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('designation')}}: {{PartnerRegistrationProvider::PartnerRegistration('designation')}}</label>
                            </div>
                            @if(!PartnerRegistrationProvider::PartnerRegistrationRejectStatus())
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('verification_status')}}: <span style="color: #FF0000; font-weight: bold;"><?=@$partner_page_data->status_reject_text?></span></label>
                                </div>
                                    <a href="#go-to-reason" class="btn btn-secondary btn-ctn">{{ HelperServiceProvider::GetLanguageText('go_to_reason')}}</a>
                            @elseif(!PartnerRegistrationProvider::PartnerRegistrationUnderProcess())
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('verification_status')}}: <span style="color: #FFA700; font-weight: bold;"><?=@$partner_page_data->status_under_process_text?></span></label>
                                </div>
                            @elseif(!PartnerRegistrationProvider::PartnerRegistrationCompleted())
                                <div class="form_group full_label half_grid face-field profile_check"
                                    style="padding-bottom: 20px;">
                                    <label>{{ HelperServiceProvider::GetLanguageText('verification_status')}}: <span style="color: #38A7A3; font-weight: bold;"><?=@$partner_page_data->status_success_text?></span></label>
                                </div>
                            @endif
                        </form>
                    </div>
                </div>
                <div class="right_grid right_side_profile">
                    <div class="right_gray_bg basice_information Financial-Information">
                        <div class="right__side_img">
                            <img src="{{url($partner_page_data->page_7_image)}}" alt="Financial-Information">
                        </div>
                    </div>
                </div>
            </div>
            @if(!PartnerRegistrationProvider::PartnerRegistrationRejectStatus())
                <div class="form_border mt-5" id="go-to-reason">
                    @include('frontend.become_a_partner.registration.edit')
                </div>
            @endif

        </div>
    </section>
@endsection
@section('script')
    @if (session('status'))
        <script>
            window.addEventListener('load', function() {
                AlertMassage(`<p>Thank you for registration as a partner with us. <br>Profile under verification</p>`);
            });
        </script>
    @endif
     @if (session('status1'))
        <script>
            window.addEventListener('load', function() {
                 AlertMassage(`<p>Thank you for submitting details. <br>Profile under verification</p>`);
            });
        </script>
    @endif

    @if(!PartnerRegistrationProvider::PartnerRegistrationRejectStatus())

        {{-- image upload / check--}}
        <script>
            // document.getElementById('patner_registration').addEventListener('change', function (event) {
            $( document ).ready(function() {
                var fileInputs = document.querySelectorAll('input[type="file"]');
                var allowedExtensions = ['png', 'jpg', 'pdf'];
                fileInputs.forEach(function (fileInput) {
                    fileInput.addEventListener('change', function () {
                        var fileName = this.value.split('\\').pop(); // Get the file name from the path
                        // Check if the file extension is allowed
                        var fileExtension = fileName.split('.').pop().toLowerCase();
                        if (allowedExtensions.indexOf(fileExtension) === -1) {
                            // alert('Invalid file type. Allowed types are PNG, JPG, and PDF.');
                            this.value = ''; // Clear the input field
                            $(this).parent().find(".title").text('+Attach');
                            // color
                            $(this).parent().find("i").removeClass().addClass('fa fa-paperclip');
                            $(this).parent().find("i, .title").css({
                                'color': 'black'
                            });
                            $(this).parent().parent().find('.error').show();
                            $(this).parent().css({
                                'border': ' 2px solid red'
                            });
                        } else {
                            var labelVal = $(this).parent().find(".title").text();
                            var oldfileName = $(this).val();
                            var extension = fileName.split('.').pop();
                            if (fileName) {
                                if (fileName.length > 10) {
                                    $(this).parent().find(".title").text(fileName.slice(0, 4) + '...' + extension);
                                } else {
                                    $(this).parent().find(".title").text(fileName);
                                }
                            } else {
                                $(this).parent().find(".title").text(labelVal);
                            }
                            // color
                            $(this).parent().find("i").removeClass().addClass('fa fa-file-image-o');
                            $(this).parent().find("i, .title").css({
                                'color': '#208440'
                            });
                            $(this).parent().css({
                                'border': ' 2px solid #208440'
                            });
                            $(this).parent().parent().find('.error').hide();
                        }
                    });
                });
            });
        </script>
        {{-- form validation --}}
        <script>
            jQuery(function() {
                // Add custom validation method for country field
                $.validator.addMethod("validFile", function (value) {
                    var count=0;
                    $('.FileUpload1').each(function(){
                        if($(this).val()==''){
                            $(this).parent().css({ 'border': ' 2px solid red' });
                            $(this).parent().parent().find('.error').show();
                            count++;
                        }
                    });
                    return count==0;
                },'');
                // Custom validation method for checking Calling Code
                $.validator.addMethod("CallingCode", function(value, element) {
                    return ($('#company_calling_code').val())?true:false;
                }, "Please select Calling code.");
                jQuery("form[name='patner_registration']").validate({
                    rules: {
                        designation: {
                            required: true,
                            maxlength:41,
                            minlength:2
                        },
                        how_did_you_hear_about_our_program:'required',
                        in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner:'required',
                        individual_business:'required',
                        address_2:{
                            required: true,
                            maxlength:101
                        },
                        company_phone:{
                           CallingCode:true,
                            required:true,
                            digits:true
                        },
                        what_is_your_primary_business_domain_focus:'required',
                        primary_company_website_or_social_media_page:'required',
                        short_description_of_your_company:'required',
                        what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year:'required',
                        do_you_have_a_single_primary_vertical_market:'required',
                        what_is_your_company_primary_vertical_market_focus:'required',
                        company_registration_number: {
                            validFile : true,
                            required: true
                        },
                        passport_number:{
                            validFile : true,
                            required: true
                        },
                        gst_number:{
                            validFile : true,
                            required: true
                        },
                        pan_number:{
                            validFile : true,
                            required: true
                        },
                        aadhar_card_number:{
                            validFile : true,
                            required: true
                        },
                        acra_number:{
                            validFile : true,
                            required: true
                        },
                        trn_number:{
                            validFile : true,
                            required: true
                        },
                        tax_registration_number:{
                            validFile : true,
                            required: true
                        },
                        npwp_number:{
                            validFile : true,
                            required: true
                        },
                        partner_agrement_and_confirm:{
                            validFile : true,
                            required: true
                        }
                    },
                    // Specify validation error messages
                    messages: {
                        designation:{
                            required: "Please enter designation",
                            maxlength: "Company name must be less then 40 characters long.",
                            minlength: "Company name must be greater then 2 characters long."
                        },
                        how_did_you_hear_about_our_program:"Please select How did you hear about our program.",
                        in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner:"Please select In what region do you want to represent Aurobees as a channel partner.",
                        individual_business:"Please check Individual / Business",
                        address_2:{
                            maxlength: "address must be less then 100 characters long.",
                            required: "Please enter address line 2."
                        },
                        company_phone: {
                            required: "Please enter phone number.",
                            minlength: "Your phone number must be at least 10 digits long",
                            maxlength: "Your phone number must be less or equal 15 digits long"
                        },
                        what_is_your_primary_business_domain_focus : "Please enter What is your primary business domain focus",
                        primary_company_website_or_social_media_page : "Please enter Primary Company Website or Social Media Page",
                        short_description_of_your_company : "Please enter Short Description",
                        what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year : "Please select Please select What was the total sales and services revenue generated by your company in its last fiscal year (USD).",
                        do_you_have_a_single_primary_vertical_market : "Please select Please select Do you have a single primary vertical market?.",
                        what_is_your_company_primary_vertical_market_focus : "Please select Please select What is your company’s primary vertical market focus.",
                        company_registration_number : {
                            required:"Please Enter Company Registration Number."
                        },
                        passport_number : "Please Enter Passport Number.",
                        gst_number : "Please Enter GST Number.",
                        pan_number : "Please Enter PAN Number.",
                        aadhar_card_number : "Please Enter Aadhar Card Number.",
                        acra_number : "Please Enter ACRA Number.",
                        trn_number : "Please Enter TRN Number.",
                        npwp_number : "Please Enter NPWP Number.",
                        partner_agrement_and_confirm : "Please accept term and condition.",
                        tax_registration_number : "Please Enter tax registration number."
                    },
                    submitHandler: function(form) {
                        form.submit();
                    }
                });
            });
        </script>
        <script>
            $('.error-calling_code').hide();
            setTimeout(() => {
                $("#what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year").val("<?=@$total_sales?>").change();
                $("#what_is_your_company_primary_vertical_market_focus").val("<?=@$what_is_your_company_primary_vertical_market_focus?>").change();
            }, 1000);
            //phone
            jQuery(document).on('keypress', '#pincode,#company_phone', function(event) {
                var regex = new RegExp("^[0-9]+$");
                var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
                if (!regex.test(key)) {
                    event.preventDefault();
                    return false;
                }
            });
            //Street  Address
            jQuery(document).on('keypress', '#address,#address_2,#what_is_your_primary_business_domain_focus,#primary_company_website_or_social_media_page,#short_description_of_your_company', function(event) {
                jQuery('.error-address').hide();
                $(this).css({'text-transform': 'capitalize'});
                var regex = new RegExp("^[a-zA-Z0-9 .' ,-]+$");
                var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
                if (!regex.test(key)) {
                    event.preventDefault();
                    return false;
                }
            });
            //calling code
            @php $company_calling_code=PartnerRegistrationProvider::PartnerRegistration('company_calling_code'); @endphp
            var intl=$('#company_phone').intlTelInput({
            initialCountry: "<?=($company_calling_code)?$company_calling_code:'auto'?>",
            separateDialCode: true,
            });
            // change calling code
            $('body').on('click keydown keypress touchstart pointerdown', '.iti__country.iti__standard', function() {
                var flagElement = $(this).find('.iti__flag').attr('class');
                var newText = flagElement.replace("iti__flag iti__", "");
                $('#company_calling_code').val(newText);
            });
        </script>
    @endif
@endsection

