@php

$meta_title = 'Aurobees | Billing';

$meta_description = '';

$meta_keywords = '';

$add_class_header='show-nav';

$footer_sign_up_for_free_trial=true;

$active_page='customer-billing';

@endphp

@extends('frontend.user.includes.master')

@section('body')

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">

<div class="dashboard_bg">

    <section class="usr_dashboard_user">

        <div class="container">

            <div class="row">

                <div class="col-md-3"></div>

                <div class="col-md-9">

                    <div class="usr_dashboard_title">

                        <h1>Billing</h1>

                        <div class="d-flex">

                            <div class="log_out_btn">

                                <a href="javascript:void(0);" onclick="$('#logout-form').submit();">Log Out</a>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="row">

                <div class="col-md-3">

                    @include('frontend.customer.includes.body.sidebar')

                </div>

                <div class="col-md-9">

                    <div class="scroll_screen">

                        <div class="dashboard_right dashboard_subscriptions">

                            <div class="data_table_wrap">

                                <div class="table__strip">

                                    <div class="total_record">

                                        <div class="check_input">

                                            <input type="checkbox">

                                            <label for="">Total Records @if($datas)<span>

                                                    <?= @sizeof($datas) ?>

                                                </span>@endif </label>

                                        </div>

                                    </div>

                                    <div class="download__list">

                                        <a href="{{route('customer.billing.excel')}}">Download</a>

                                    </div>

                                </div>

                                <table id="DataTable" class="table table-striped nowrap">

                                    <thead>

                                        <tr>

                                            <th>No</th>

                                            <th>Subscribe Billing No</th>

                                            <th>LOB Name</th>

                                            <th>LOB Type</th>

                                            <th>LOB Plan</th>

                                            <th>User</th>

                                            <th>Form Date</th>

                                            <th>Due Date</th>

                                            <th>Amount</th>

                                            <th>Status</th>

                                            <th>Paid Date</th>

                                            <th>Action</th>

                                        </tr>

                                    </thead>

                                    <tbody>

                                        @if($datas)

                                        @foreach ($datas as $key => $data)

                                        <tr>

                                            <td>

                                                <div class="check_input">

                                                    <input type="checkbox">

                                                    <label for="">{{ $key + 1 }}</label>

                                                </div>

                                            </td>

                                            <td>{{$data->serial_number}}</td>

                                            <td>{{ $data['Pricing']['LOB']['title'] }}</td>

                                            <td><?= @$data->plan_name ?></td>

                                            @php if($data->plan_duration=='YLY'){ $plan_duration=365; }elseif($data->plan_duration=='QTR'){ $plan_duration=90; }elseif($data->plan_duration=='MTH'){ $plan_duration=30; }else{ $plan_duration=15; } @endphp

                                            <td><?=$plan_duration?> Days</td>

                                            <td><?=(@$data->plan_name=='Ecommerce')?1:@$data->quantity ?></td>

                                            <td>{{ $data->start_at }}</td>

                                            <td>{{ $data->end_at }}</td>

                                            <td>{{$data->currency_code.' '. number_format($data->grand_amount, 2) }}

                                            </td>

                                            <td>
                                                @if($data->plan_name=='Free-Trial') Upgrade @else Paid @endif
                                                {{-- ----------status--------------- --}}
                                                <?php $currentDate = date('Y-m-d H:i:s');
                                                $featureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' + ' . $subscription_upgrade_days . 'days')); ?>
                                                @if ($data->upgrade_status =='0' && $data->plan_name=='Free-Trial')
                                                    <p>If you want to upgrade to paid version, Kindly <a href="javascript:void(0);" onclick="subscriptionUpgrade('{{Crypt::encrypt($data->id)}}');">Upgrade now</a></p>
                                                @elseif($featureDate>=$data->end_at && $data->upgrade_status =='0' &&
                                                    $data->status=='Active' && $data->plan_name!='Free-Trial')
                                                    <p><a href="javascript:void(0);" onclick="subscriptionPay('{{route('customer.subscription.paid',Crypt::encrypt($data->id))}}', '{{$data->country_code}}', '{{$plan_duration}}', '{{$data->currency_code}}', '{{$data->grand_amount}}');">Pay now</a></p>
                                                @elseif($data->payment_mode=='auropay' && $data->status=='Pending')
                                                    <a href="{{route('customer.subscription.payment.auropay',Crypt::encrypt($data->id))}}">Pay now</a>
                                                @endif
                                            </td>

                                            <td>{{ $data->start_at }}</td>

                                            <td>

                                                <a href="javascript:void(0);" onclick="viewDetailBilling('{{route('customer.billing.show',Crypt::encrypt($data->id))}}');"><i id="eyeIcon_table" class="fa fa-eye"></i></a>

                                                <a href="{{route('customer.billing.pdf',Crypt::encrypt($data->id))}}"><img width="15" src="{{url('frontend/images/download-icon1.png')}}" alt="img"></a>

                                            </td>

                                        </tr>

                                        @endforeach

                                        @endif

                                    </tbody>

                                </table>

                            </div>

                        </div>

                    </div>

                </div>

            </div>
            @include('frontend.customer.includes.body.help-center-mobile')
        </div>

    </section>

</div>

{{-- model --}}

<div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle"

    aria-hidden="true">

    <div class="modal-dialog modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header">

                <h5 class="modal-title" id="exampleModalLongTitle">Billing Details</h5>

                <button type="button" class="close" onclick="$('#exampleModalLong').modal('hide');" aria-label="Close">

                    <span aria-hidden="true">&times;</span>

                </button>

            </div>

            <div class="modal-body add-subscription-data">

            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-secondary"

                    onclick="$('#exampleModalLong').modal('hide');">Close</button>

            </div>

        </div>

    </div>

</div>

{{-- model --}}

<div class="modal fade" id="subscription-upgrade" tabindex="-1" role="dialog" aria-labelledby="subscription-upgrade"

    aria-hidden="true">

    <div class="modal-dialog modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-body add-subscription-upgrade-html">

            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-secondary"

                    onclick="$('#subscription-upgrade').modal('hide');">Close</button>

            </div>

        </div>

    </div>

</div>

{{-- model subscription pay --}}

<div class="modal fade" id="subscription-pay" tabindex="-1" role="dialog" aria-labelledby="subscription-pay"

    aria-hidden="true">

    <div class="modal-dialog modal-lg modal-dialog-centered " role="document">

        <div class="modal-content">

            <div class="modal-header"></div>

            <div class="modal-body add-subscription-pay-html">

                <div class="tab-content">

                    <div class="form_content_inner">

                        <form action="" method="get" id="subscription-pay-form">

                            <div class="payment_description">

                                <ul>

                                    <li>

                                        <strong>Payment Mode</strong>

                                        <div class="pay_method_grid">

                                            <div class="choose_meethod">

                                                <input type="radio" id="Offline" checked  name="payment_mode" value="Offline">

                                                <label for="Offline">Offline</label>

                                            </div>

                                            <!--<div class="choose_meethod auropay-div">-->

                                            <!--    <input type="radio" id="auropay" disabled name="payment_mode" value="auropay">-->

                                            <!--    <label for="auropay">AuroPay</label>-->

                                            <!--</div>-->

                                        </div>

                                    </li>

                                </ul>

                            </div>

                            <div class="subscribe_div">

                                <button type="submit">Pay Now</button>

                            </div>

                        </form>

                        

                        <h2>Total Amount: <span id="model-total-amount"></span></h2>

                        <p>Start Date: <span id="model-total-start-date"></p>

                        <p>Expiry Date: <span id="model-total-end-date"></p>

                    </div>

                </div>

            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-secondary"

                    onclick="$('#subscription-pay').modal('hide');">Close</button>

            </div>

        </div>

    </div>

</div>

@endsection

@section('script')

<script>

    window.addEventListener('load', function () {

        @if (Session:: has('message'))

    AlertMassage(`<?= Session::get('message') ?>`);

    @endif

    });

</script>

<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>

    $(document).ready(function () {

        $('.data_table_wrap .dataTables_wrapper table').wrap('<div class="scroll_table" />');

    });

    new DataTable('#DataTable', {});

    function viewDetailBilling(url) {

        $.ajax({

            type: "GET",

            url: url,

            success: function (response) {

                $('.add-subscription-data').html(response);

                $('#exampleModalLong').modal('show');

            },

            error: function (xhr, status, error) {

                AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);

            }

        });

    }

    function subscriptionUpgrade(token) {

        $.ajax({

            type: "GET",

            url: "{{route('customer.subscription.upgrade')}}",

            data: { 'token': token },

            success: function (response) {

                if (response) {

                    $('.add-subscription-upgrade-html').html(response);

                    $('#subscription-upgrade').modal('show');

                } else {

                    AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);

                }

            },

            error: function (xhr, status, error) {

                AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);

            }

        });

    }



    function subscriptionPay(url, country_code, plan_duration, currency_code, grand_amount) {

        $('#subscription-pay-form').attr('action', url);

        $('#model-total-amount').text(currency_code +' '+grand_amount);

        var currentDate = new Date();

        var newDate = new Date(currentDate);

        newDate.setDate(newDate.getDate() + 30);

        $('#model-total-start-date').text(formatDate(currentDate));

        $('#model-total-end-date').text(formatDate(newDate));



        if(country_code=='IN' || country_code=='ID'){

            $('.auropay-div').show();

        }else{

            //$('.auropay-div').hide();

        }

        $('#subscription-pay').modal('show');

    }

    // Function to format date as Y-m-d

    function formatDate(date) {

        var year = date.getFullYear();

        var month = ('0' + (date.getMonth() + 1)).slice(-2); // Months are zero-indexed

        var day = ('0' + date.getDate()).slice(-2);

        return year + '-' + month + '-' + day;

    }

</script>

@endsection

